"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_SETTINGS_SPEC = exports.settingsBuildProps = void 0;
const brush_axis_1 = require("./brush_axis");
const default_legend_config_1 = require("./default_legend_config");
const pointer_update_trigger_1 = require("./pointer_update_trigger");
const spec_type_1 = require("./spec_type");
const chart_types_1 = require("../chart_types");
const spec_factory_1 = require("../state/spec_factory");
const light_theme_1 = require("../utils/themes/light_theme");
exports.settingsBuildProps = (0, spec_factory_1.buildSFProps)()({
    id: '__global__settings___',
    chartType: chart_types_1.ChartType.Global,
    specType: spec_type_1.SpecType.Settings,
}, {
    rendering: 'canvas',
    rotation: 0,
    animateData: true,
    debug: false,
    pointerUpdateTrigger: pointer_update_trigger_1.PointerUpdateTrigger.X,
    externalPointerEvents: {
        tooltip: {
            visible: false,
        },
    },
    baseTheme: light_theme_1.LIGHT_THEME,
    brushAxis: brush_axis_1.BrushAxis.X,
    minBrushDelta: 2,
    ariaUseDefaultSummary: true,
    ariaLabelHeadingLevel: 'p',
    allowBrushingLastHistogramBin: true,
    pointBuffer: 10,
    ...default_legend_config_1.DEFAULT_LEGEND_CONFIG,
    locale: 'en-US',
    dow: 1,
});
exports.DEFAULT_SETTINGS_SPEC = {
    ...exports.settingsBuildProps.defaults,
    ...exports.settingsBuildProps.overrides,
};
//# sourceMappingURL=default_settings_spec.js.map