"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_DEBUG_STROKE = exports.DEFAULT_DEBUG_FILL = void 0;
exports.renderDebugRect = renderDebugRect;
exports.renderDebugRectCenterRotated = renderDebugRectCenterRotated;
exports.renderDebugPoint = renderDebugPoint;
const __1 = require("../");
const color_library_wrappers_1 = require("../../../common/color_library_wrappers");
const colors_1 = require("../../../common/colors");
const rect_1 = require("../../../renderers/canvas/primitives/rect");
const common_1 = require("../../../utils/common");
exports.DEFAULT_DEBUG_FILL = {
    color: (0, color_library_wrappers_1.overrideOpacity)(colors_1.Colors.Violet.rgba, 0.2),
};
exports.DEFAULT_DEBUG_STROKE = {
    color: [0, 0, 0, 0.2],
    width: 1,
};
function renderDebugRect(ctx, rect, rotation = 0, fill = exports.DEFAULT_DEBUG_FILL, stroke = exports.DEFAULT_DEBUG_STROKE) {
    (0, __1.withContext)(ctx, () => {
        ctx.translate(rect.x, rect.y);
        ctx.rotate((0, common_1.degToRad)(rotation));
        (0, rect_1.renderRect)(ctx, { ...rect, x: 0, y: 0 }, fill, stroke, true);
    });
}
function renderDebugRectCenterRotated(ctx, center, rect, fill = exports.DEFAULT_DEBUG_FILL, stroke = exports.DEFAULT_DEBUG_STROKE, rotation = 0) {
    const { x, y } = center;
    (0, __1.withContext)(ctx, () => {
        ctx.translate(x, y);
        ctx.rotate((0, common_1.degToRad)(rotation));
        ctx.translate(-x, -y);
        (0, rect_1.renderRect)(ctx, { ...rect, x: x - rect.width / 2, y: y - rect.height / 2 }, fill, stroke);
    });
}
function renderDebugPoint(ctx, x, y, size = 16, stroke = exports.DEFAULT_DEBUG_STROKE) {
    (0, __1.withContext)(ctx, () => {
        ctx.beginPath();
        ctx.lineWidth = stroke.width;
        ctx.strokeStyle = (0, color_library_wrappers_1.RGBATupleToString)(stroke.color);
        ctx.moveTo(x - size, y);
        ctx.lineTo(x + size, y);
        ctx.moveTo(x, y - size);
        ctx.lineTo(x, y + size);
        ctx.stroke();
    });
}
//# sourceMappingURL=debug.js.map