"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logarithm = logarithm;
exports.extent = extent;
function logarithm(base, y) {
    return Math.log(y) / Math.log(base);
}
function extent(array) {
    const len = array.length;
    let min = Infinity;
    let max = -Infinity;
    for (let i = 0; i < len; i += 1) {
        const value = array[i] ?? NaN;
        if (min > value)
            min = value;
        if (max < value)
            max = value;
    }
    return [min, max];
}
//# sourceMappingURL=math.js.map