// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
import { FixedWidthBuilder } from '../builder.mjs';
import { setIntervalValue, setIntervalDayTime, setIntervalYearMonth, setIntervalMonthDayNano } from '../visitor/set.mjs';
/** @ignore */
export class IntervalBuilder extends FixedWidthBuilder {
}
IntervalBuilder.prototype._setValue = setIntervalValue;
/** @ignore */
export class IntervalDayTimeBuilder extends IntervalBuilder {
}
IntervalDayTimeBuilder.prototype._setValue = setIntervalDayTime;
/** @ignore */
export class IntervalYearMonthBuilder extends IntervalBuilder {
}
IntervalYearMonthBuilder.prototype._setValue = setIntervalYearMonth;
/** @ignore */
export class IntervalMonthDayNanoBuilder extends IntervalBuilder {
}
IntervalMonthDayNanoBuilder.prototype._setValue = setIntervalMonthDayNano;

//# sourceMappingURL=interval.mjs.map
