"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.maybeNegate = void 0;
const Operations_1 = require("./Operations");
function maybeNegate(clause, value) {
    if (clause.negate) {
        return !value;
    }
    return value;
}
exports.maybeNegate = maybeNegate;
function matchAny(op, value, values) {
    return values.some((testValue) => Operations_1.default.execute(op, value, testValue));
}
/**
 * Match a clause against a context.
 * @param clause The clause to match against a context.
 * @param context The context to match.
 * @returns True if the clause matches.
 *
 * @internal
 */
function matchClauseWithoutSegmentOperations(clause, context) {
    const contextValue = context.valueForKind(clause.attributeReference, clause.contextKind);
    if (contextValue === null || contextValue === undefined) {
        return false;
    }
    if (Array.isArray(contextValue)) {
        return maybeNegate(clause, contextValue.some((value) => matchAny(clause.op, value, clause.values)));
    }
    return maybeNegate(clause, matchAny(clause.op, contextValue, clause.values));
}
exports.default = matchClauseWithoutSegmentOperations;
//# sourceMappingURL=matchClause.js.map