"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVisualizeAppState = createVisualizeAppState;
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _migrate_app_state = require("./migrate_app_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const STATE_STORAGE_KEY = '_a';
function toObject(state) {
  return (0, _lodash.omitBy)(state, (value, key) => {
    return key.charAt(0) === '$' || key.charAt(0) === '_' || (0, _lodash.isFunction)(value);
  });
}
const pureTransitions = {
  set: state => (prop, value) => ({
    ...state,
    [prop]: value
  }),
  setVis: state => vis => ({
    ...state,
    vis: {
      ...state.vis,
      ...vis
    }
  }),
  unlinkSavedSearch: state => ({
    query,
    parentFilters = []
  }) => ({
    ...state,
    query: query || state.query,
    filters: (0, _lodash.union)(state.filters, parentFilters),
    linked: false
  }),
  updateDataView: state => dataViewId => ({
    ...state,
    dataView: dataViewId
  }),
  updateVisState: state => newVisState => ({
    ...state,
    vis: toObject(newVisState)
  }),
  updateSavedQuery: state => savedQueryId => {
    const updatedState = {
      ...state,
      savedQuery: savedQueryId
    };
    if (!savedQueryId) {
      delete updatedState.savedQuery;
    }
    return updatedState;
  }
};
function createVisualizeByValueAppState(stateDefaults) {
  const initialState = (0, _migrate_app_state.migrateAppState)({
    ...stateDefaults
  });
  const stateContainer = (0, _public.createStateContainer)(initialState, pureTransitions);
  const stopStateSync = () => {};
  return {
    stateContainer,
    stopStateSync
  };
}
function createDefaultVisualizeAppState({
  stateDefaults,
  kbnUrlStateStorage
}) {
  const urlState = kbnUrlStateStorage.get(STATE_STORAGE_KEY);
  const initialState = (0, _migrate_app_state.migrateAppState)({
    ...stateDefaults,
    ...urlState
  });
  /*
     make sure url ('_a') matches initial state
     Initializing appState does two things - first it translates the defaults into AppState,
     second it updates appState based on the url (the url trumps the defaults). This means if
     we update the state format at all and want to handle BWC, we must not only migrate the
     data stored with saved vis, but also any old state in the url.
   */
  kbnUrlStateStorage.set(STATE_STORAGE_KEY, initialState, {
    replace: true
  });
  const stateContainer = (0, _public.createStateContainer)(initialState, pureTransitions);
  const {
    start: startStateSync,
    stop: stopStateSync
  } = (0, _public.syncState)({
    storageKey: STATE_STORAGE_KEY,
    stateContainer: {
      ...stateContainer,
      set: state => {
        if (state) {
          // syncState utils requires to handle incoming "null" value
          stateContainer.set(state);
        }
      }
    },
    stateStorage: kbnUrlStateStorage
  });
  // start syncing the appState with the ('_a') url
  startStateSync();
  return {
    stateContainer,
    stopStateSync
  };
}
function createVisualizeAppState({
  stateDefaults,
  kbnUrlStateStorage,
  byValue
}) {
  if (byValue) {
    return createVisualizeByValueAppState(stateDefaults);
  }
  return createDefaultVisualizeAppState({
    stateDefaults,
    kbnUrlStateStorage
  });
}