"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeApp = void 0;
require("./app.scss");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _components = require("./components");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const NoDataComponent = ({
  core,
  dataViews,
  dataViewEditor,
  onDataViewCreated,
  noDataPage,
  share
}) => {
  const analyticsServices = {
    coreStart: core,
    dataViews,
    dataViewEditor,
    noDataPage,
    share
  };
  const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
  const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPageKibanaProvider: NoDataProvider
  }) => {
    return {
      default: NoDataProvider
    };
  })));
  const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPage: NoDataPage
  }) => {
    return {
      default: NoDataPage
    };
  })));
  return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated
  }));
};
const VisualizeApp = ({
  onAppLeave
}) => {
  const {
    services: {
      data: {
        query,
        dataViews
      },
      core,
      kbnUrlStateStorage,
      dataViewEditor,
      noDataPage,
      share
    }
  } = (0, _public2.useKibana)();
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const onDataViewCreated = (0, _react.useCallback)(dataView => {
    if (dataView) {
      setShowNoDataPage(false);
    }
  }, []);
  (0, _react.useEffect)(() => {
    // syncs `_g` portion of url with query services
    const {
      stop
    } = (0, _public.syncGlobalQueryStateWithUrl)(query, kbnUrlStateStorage);
    return () => stop();

    // this effect should re-run when pathname is changed to preserve querystring part,
    // so the global state is always preserved
  }, [query, kbnUrlStateStorage, pathname]);
  (0, _react.useEffect)(() => {
    const checkESOrDataViewExist = async () => {
      // check if there is any data view or data source
      const hasUserDataView = await dataViews.hasData.hasUserDataView().catch(() => false);
      if (hasUserDataView) {
        // Adding this check as TSVB asks for the default dataview on initialization
        const defaultDataView = await dataViews.defaultDataViewExists();
        if (!defaultDataView) {
          setShowNoDataPage(true);
        }
        setIsLoading(false);
        return;
      }
      setShowNoDataPage(true);
      setIsLoading(false);
    };

    // call the function
    checkESOrDataViewExist();
  }, [dataViews]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "visAppLoadingWrapper"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }));
  }

  // Visualize app should return the noData component if there is no data view or data source
  if (showNoDataPage) {
    return /*#__PURE__*/_react.default.createElement(NoDataComponent, {
      core: core,
      dataViewEditor: dataViewEditor,
      dataViews: dataViews,
      onDataViewCreated: onDataViewCreated,
      noDataPage: noDataPage,
      share: share
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${_constants.VisualizeConstants.EDIT_BY_VALUE_PATH}`
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeByValueEditor, {
    onAppLeave: onAppLeave
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: [_constants.VisualizeConstants.CREATE_PATH, `${_constants.VisualizeConstants.EDIT_PATH}/:id`]
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeEditor, {
    onAppLeave: onAppLeave
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [_constants.VisualizeConstants.LANDING_PAGE_PATH, _constants.VisualizeConstants.WIZARD_STEP_1_PAGE_PATH, _constants.VisualizeConstants.LANDING_PAGE_PATH_WITH_TAB]
  }, /*#__PURE__*/_react.default.createElement(_components.VisualizeListing, null)), /*#__PURE__*/_react.default.createElement(_components.VisualizeNoMatch, null));
};
exports.VisualizeApp = VisualizeApp;