"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.displayDuplicateTitleConfirmModal = displayDuplicateTitleConfirmModal;
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _confirm_modal_promise = require("./confirm_modal_promise");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function displayDuplicateTitleConfirmModal(savedObject, startServices) {
  const confirmTitle = _i18n.i18n.translate('visualizations.confirmModal.saveDuplicateConfirmationTitle', {
    defaultMessage: `This visualization already exists`
  });
  const confirmMessage = _i18n.i18n.translate('visualizations.confirmModal.saveDuplicateConfirmationMessage', {
    defaultMessage: `Saving "{name}" creates a duplicate title. Would you like to save anyway?`,
    values: {
      name: savedObject.title
    }
  });
  const confirmButtonText = _i18n.i18n.translate('visualizations.confirmModal.saveDuplicateButtonLabel', {
    defaultMessage: 'Save'
  });
  try {
    return (0, _confirm_modal_promise.confirmModalPromise)(confirmMessage, confirmTitle, confirmButtonText, startServices);
  } catch {
    return Promise.reject(new Error(_constants.SAVE_DUPLICATE_REJECTED));
  }
}