"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisConfig = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = _interopRequireDefault(require("lodash"));
var _types = require("./types");
var _data = require("./data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Provides vislib configuration, throws error if invalid property is accessed without providing defaults
 */

const DEFAULT_VIS_CONFIG = {
  style: {
    margin: {
      top: 10,
      right: 3,
      bottom: 5,
      left: 3
    }
  },
  categoryAxes: [],
  valueAxes: [],
  grid: {}
};
class VisConfig {
  constructor(visConfigArgs, data, uiState, el, createColorLookupFunction) {
    this.data = new _data.Data(data, uiState, createColorLookupFunction);
    const visType = _types.vislibTypesConfig[visConfigArgs.type];
    const typeDefaults = visType(visConfigArgs, this.data);
    this._values = _lodash.default.defaultsDeep({
      ...typeDefaults
    }, DEFAULT_VIS_CONFIG);
    this._values.el = el;
  }
  get(property, defaults) {
    if (_lodash.default.has(this._values, property) || typeof defaults !== 'undefined') {
      return _lodash.default.get(this._values, property, defaults);
    } else {
      throw new Error(`Accessing invalid config property: ${property}`);
    }
  }
  set(property, value) {
    return (0, _saferLodashSet.set)(this._values, property, value);
  }
}
exports.VisConfig = VisConfig;