"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertTSVBtoLensConfiguration = void 0;
var _enums = require("../../common/enums");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getConvertFnByType = type => {
  var _convertionFns$type;
  const convertionFns = {
    [_enums.PANEL_TYPES.TIMESERIES]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./timeseries')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.TOP_N]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./top_n')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.METRIC]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./metric')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.GAUGE]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./gauge')));
      return convertToLens;
    },
    [_enums.PANEL_TYPES.TABLE]: async () => {
      const {
        convertToLens
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./table')));
      return convertToLens;
    }
  };
  return (_convertionFns$type = convertionFns[type]) === null || _convertionFns$type === void 0 ? void 0 : _convertionFns$type.call(convertionFns);
};

/*
 * This function is used to convert the TSVB model to compatible Lens model.
 * Returns the Lens model, only if it is supported. If not, it returns null.
 * In case of null, the menu item is disabled and the user can't navigate to Lens.
 */
const convertTSVBtoLensConfiguration = async (vis, timeRange) => {
  var _await$convertFn;
  // Disables if model is invalid
  if (vis.params.isModelInvalid) {
    return null;
  }
  const convertFn = await getConvertFnByType(vis.params.type);
  return (_await$convertFn = await (convertFn === null || convertFn === void 0 ? void 0 : convertFn(vis, timeRange))) !== null && _await$convertFn !== void 0 ? _await$convertFn : null;
};
exports.convertTSVBtoLensConfiguration = convertTSVBtoLensConfiguration;