"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ICON_TYPES_MAP = exports.ICON_NAMES = void 0;
var _bomb_icon = require("../../components/svg/bomb_icon");
var _fire_icon = require("../../components/svg/fire_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ICON_NAMES = exports.ICON_NAMES = {
  ASTERISK: 'fa-asterisk',
  BELL: 'fa-bell',
  BOLT: 'fa-bolt',
  BOMB: 'fa-bomb',
  BUG: 'fa-bug',
  COMMENT: 'fa-comment',
  EXCLAMATION_TRIANGLE: 'fa-exclamation-triangle',
  FIRE: 'fa-fire',
  FLAG: 'fa-flag',
  HEART: 'fa-heart',
  MAP_MARKER: 'fa-map-marker',
  MAP_PIN: 'fa-map-pin',
  STAR: 'fa-star',
  TAG: 'fa-tag'
};
const ICON_TYPES_MAP = exports.ICON_TYPES_MAP = {
  [ICON_NAMES.ASTERISK]: 'asterisk',
  [ICON_NAMES.BELL]: 'bell',
  [ICON_NAMES.BOLT]: 'bolt',
  [ICON_NAMES.BOMB]: _bomb_icon.bombIcon,
  [ICON_NAMES.BUG]: 'bug',
  [ICON_NAMES.COMMENT]: 'editorComment',
  [ICON_NAMES.EXCLAMATION_TRIANGLE]: 'warning',
  [ICON_NAMES.FIRE]: _fire_icon.fireIcon,
  [ICON_NAMES.FLAG]: 'flag',
  [ICON_NAMES.HEART]: 'heart',
  [ICON_NAMES.MAP_MARKER]: 'mapMarker',
  [ICON_NAMES.MAP_PIN]: 'pinFilled',
  [ICON_NAMES.STAR]: 'starFilled',
  [ICON_NAMES.TAG]: 'tag'
};