"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TopNVisualization;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _services = require("../../../../services");
var _get_metrics_field = require("../../lib/get_metrics_field");
var _tick_formatter = require("../../lib/tick_formatter");
var _create_field_formatter = require("../../lib/create_field_formatter");
var _top_n = require("../../../visualizations/views/top_n");
var _last_value_utils = require("../../../../../common/last_value_utils");
var _set_is_reversed = require("../../../lib/set_is_reversed");
var _replace_vars = require("../../lib/replace_vars");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _enums = require("../../../../../common/enums");
var _operators_utils = require("../../../../../common/operators_utils");
var _external_url_error_modal = require("../../lib/external_url_error_modal");
var _constants = require("../../../../../common/constants");
var _vis_types = require("../_vis_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function sortByDirection(data, direction, fn) {
  if (direction === 'desc') {
    return (0, _lodash.sortBy)(data, fn).reverse();
  }
  return (0, _lodash.sortBy)(data, fn);
}
function sortSeries(visData, model) {
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []);
  return model.series.reduce((acc, item) => {
    const itemSeries = series.filter(s => {
      const id = (0, _lodash.first)(s.id.split(_constants.SERIES_SEPARATOR));
      return id === item.id;
    });
    const direction = item.terms_direction || 'desc';
    if (item.terms_order_by === '_key') return acc.concat(itemSeries);
    return acc.concat(sortByDirection(itemSeries, direction, s => (0, _last_value_utils.getLastValue)(s.data)));
  }, []);
}
function TopNVisualization(props) {
  const [accessDeniedDrilldownUrl, setAccessDeniedDrilldownUrl] = (0, _react.useState)(null);
  const coreStart = (0, _services.getCoreStart)();
  const {
    backgroundColor,
    model,
    visData,
    fieldFormatMap,
    getConfig
  } = props;
  const series = sortSeries(visData, model).map(item => {
    const id = (0, _lodash.first)(item.id.split(_constants.SERIES_SEPARATOR));
    const seriesConfig = model.series.find(s => s.id === id);
    if (seriesConfig) {
      const tickFormatter = seriesConfig.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(seriesConfig.metrics), fieldFormatMap, 'html') : (0, _tick_formatter.createTickFormatter)(seriesConfig.formatter, seriesConfig.value_template, getConfig);
      const value = (0, _last_value_utils.getLastValue)(item.data);
      let color = item.color || seriesConfig.color;
      if (model.bar_color_rules) {
        model.bar_color_rules.forEach(rule => {
          if ((0, _operators_utils.shouldOperate)(rule, value) && rule.operator && rule.bar_color) {
            if ((0, _operators_utils.getOperator)(rule.operator)(value, rule.value)) {
              color = rule.bar_color;
            }
          }
        });
      }
      return {
        ...item,
        color,
        tickFormatter
      };
    }
    return item;
  });
  const panelBackgroundColor = model.background_color || backgroundColor;
  const style = {
    backgroundColor: panelBackgroundColor
  };
  const params = {
    series: series,
    reversed: (0, _set_is_reversed.isBackgroundInverted)(panelBackgroundColor)
  };
  if (model.drilldown_url) {
    params.onClick = item => {
      const url = (0, _replace_vars.replaceVars)(model.drilldown_url, {}, {
        key: item.label
      }, {
        noEscape: true
      });
      const validatedUrl = coreStart.http.externalUrl.validateUrl(url);
      if (validatedUrl) {
        setAccessDeniedDrilldownUrl(null);
        coreStart.application.navigateToUrl(url);
      } else {
        setAccessDeniedDrilldownUrl(url);
      }
    };
  }
  const closeExternalUrlErrorModal = (0, _react.useCallback)(() => setAccessDeniedDrilldownUrl(null), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbVis",
    style: style,
    css: _vis_types.visStyles
  }, /*#__PURE__*/_react.default.createElement(_top_n.TopN, (0, _extends2.default)({}, params, {
    initialRender: props.initialRender
  })), accessDeniedDrilldownUrl && /*#__PURE__*/_react.default.createElement(_external_url_error_modal.ExternalUrlErrorModal, {
    url: accessDeniedDrilldownUrl,
    handleClose: closeExternalUrlErrorModal
  }));
}
TopNVisualization.propTypes = {
  backgroundColor: _propTypes.default.string,
  className: _propTypes.default.string,
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  onChange: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;