"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editorVisualizationStyle = exports.applyStyle = exports.VisEditorVisualization = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const editorVisualizationStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: relative;
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  width: 100%;
  height: calc(${euiTheme.size.l} * 10);
  line-height: normal;
  background-color: ${euiTheme.colors.emptyShade};
  overflow: auto;
`;
exports.editorVisualizationStyle = editorVisualizationStyle;
const applyStyle = ({
  euiTheme
}) => (0, _react2.css)`
  padding: ${euiTheme.size.s};
`;
exports.applyStyle = applyStyle;
const dragHandleStyle = ({
  euiTheme
}) => {
  // Implementing the kbnResizer mixin with vertical direction

  // Default size calculation (euiSizeM + 2px)
  const defaultSize = `calc(${euiTheme.size.m} + 2px)`;

  // Implementation for vertical direction
  return (0, _react2.css)`
    position: relative;
    display: flex;
    flex: 0 0 ${defaultSize};
    background-color: ${euiTheme.colors.body};
    align-items: center;
    justify-content: center;
    margin: 0;
    user-select: none;

    height: ${defaultSize};
    width: 100%;

    &:hover {
      background-color: ${euiTheme.colors.backgroundBasePrimary};
    }

    &:focus,
    &:active {
      background-color: ${euiTheme.colors.primary};
      color: ${euiTheme.colors.emptyShade};
    }

    &::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      cursor: ns-resize;
    }
  `;
};
const MIN_CHART_HEIGHT = 300;
class VisEditorVisualizationUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleMouseDown", () => {
      window.addEventListener('mouseup', this.handleMouseUp);
      this.setState({
        dragging: true
      });
    });
    (0, _defineProperty2.default)(this, "handleMouseUp", () => {
      window.removeEventListener('mouseup', this.handleMouseUp);
      this.setState({
        dragging: false
      });
    });
    (0, _defineProperty2.default)(this, "handleMouseMove", event => {
      if (this.state.dragging) {
        this.setState(prevState => ({
          height: Math.max(MIN_CHART_HEIGHT, prevState.height + event.movementY)
        }));
      }
    });
    /**
     * Resize the chart height when pressing up/down while the drag handle
     * for resizing has the focus.
     * We use 15px steps to do the scaling and make sure the chart has at least its
     * defined minimum width (MIN_CHART_HEIGHT).
     */
    (0, _defineProperty2.default)(this, "onSizeHandleKeyDown", ev => {
      const {
        key
      } = ev;
      if (key === _eui.keys.ARROW_UP || key === _eui.keys.ARROW_DOWN) {
        ev.preventDefault();
        this.setState(prevState => {
          const newHeight = prevState.height + (key === _eui.keys.ARROW_UP ? -15 : 15);
          return {
            height: Math.max(MIN_CHART_HEIGHT, newHeight)
          };
        });
      }
    });
    this.state = {
      height: MIN_CHART_HEIGHT,
      dragging: false
    };
    this._visEl = /*#__PURE__*/_react.default.createRef();
    this._subscription = null;
  }
  async _loadVisualization() {
    if (!this._visEl.current) {
      // In case the visualize loader isn't done before the component is unmounted.
      return;
    }
    const {
      onDataChange,
      embeddableHandler,
      timeRange,
      filters,
      query
    } = this.props;
    this._handler = embeddableHandler;
    this._handler.updateInput({
      timeRange,
      filters,
      query
    });
    await this._handler.render(this._visEl.current);
    this.props.eventEmitter.emit('embeddableRendered');
    this._subscription = this._handler.handler.data$.pipe((0, _rxjs.pluck)('result')).subscribe(data => onDataChange(data.value));
  }
  componentWillUnmount() {
    window.removeEventListener('mousemove', this.handleMouseMove);
    window.removeEventListener('mouseup', this.handleMouseUp);
    if (this._handler) {
      this._handler.destroy();
    }
    if (this._subscription) {
      this._subscription.unsubscribe();
    }
  }
  componentDidMount() {
    window.addEventListener('mousemove', this.handleMouseMove);
    this._loadVisualization();
  }
  componentDidUpdate() {
    if (this._handler) {
      const {
        timeRange,
        filters,
        query
      } = this.props;
      this._handler.updateInput({
        timeRange,
        filters,
        query
      });
    }
  }
  render() {
    const {
      dirty,
      autoApply,
      title,
      description,
      onToggleAutoApply,
      onCommit
    } = this.props;
    const style = {
      height: this.state.height
    };
    if (this.state.dragging) {
      style.userSelect = 'none';
    }
    let applyMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.visEditorVisualization.changesSuccessfullyAppliedMessage",
      defaultMessage: "The latest changes have been applied."
    });
    if (dirty) {
      applyMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.visEditorVisualization.changesHaveNotBeenAppliedMessage",
        defaultMessage: "The changes to this visualization have not been applied."
      });
    }
    if (autoApply) {
      applyMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.visEditorVisualization.changesWillBeAutomaticallyAppliedMessage",
        defaultMessage: "The changes will be automatically applied."
      });
    }
    const applyButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: "tvbEditorVisualization__apply",
      css: applyStyle,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: "tsvbAutoApplyInput",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.visEditorVisualization.autoApplyLabel",
        defaultMessage: "Auto apply"
      }),
      checked: autoApply,
      onChange: onToggleAutoApply
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: dirty ? 'default' : 'subdued',
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, applyMessage))), !autoApply && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "play",
      fill: true,
      size: "s",
      onClick: onCommit,
      disabled: !dirty,
      "data-test-subj": "applyBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.visEditorVisualization.applyChangesLabel",
      defaultMessage: "Apply changes"
    }))));
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
      style: style,
      className: "tvbEditorVisualization",
      css: editorVisualizationStyle,
      "data-shared-items-container": true,
      "data-title": title,
      "data-description": description,
      ref: this._visEl
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbEditor--hideForReporting"
    }, applyButton, /*#__PURE__*/_react.default.createElement("button", {
      className: "tvbEditorVisualization__draghandle",
      css: dragHandleStyle,
      onMouseDown: this.handleMouseDown,
      onMouseUp: this.handleMouseUp,
      onKeyDown: this.onSizeHandleKeyDown,
      "aria-label": this.props.intl.formatMessage({
        id: 'visTypeTimeseries.colorRules.adjustChartSizeAriaLabel',
        defaultMessage: 'Press up/down to adjust the chart size'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "grab"
    }))));
  }
}
VisEditorVisualizationUI.propTypes = {
  model: _propTypes.default.object,
  onCommit: _propTypes.default.func,
  uiState: _propTypes.default.object,
  onToggleAutoApply: _propTypes.default.func,
  embeddableHandler: _propTypes.default.object,
  eventEmitter: _propTypes.default.object,
  timeRange: _propTypes.default.object,
  dirty: _propTypes.default.bool,
  autoApply: _propTypes.default.bool
};
const VisEditorVisualization = exports.VisEditorVisualization = (0, _i18nReact.injectI18n)(VisEditorVisualizationUI);