"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertSeriesToVars = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _enums = require("../../../../common/enums");
var _last_value_utils = require("../../../../common/last_value_utils");
var _empty_label = require("../../../../common/empty_label");
var _tick_formatter = require("./tick_formatter");
var _get_metrics_field = require("./get_metrics_field");
var _create_field_formatter = require("./create_field_formatter");
var _moment = _interopRequireDefault(require("moment"));
var _fields_utils = require("../../../../common/fields_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertSeriesToVars = (series, model, getConfig = null, fieldFormatMap, dataView) => {
  var _getConfig;
  const variables = {};
  const dateFormat = (_getConfig = getConfig === null || getConfig === void 0 ? void 0 : getConfig('dateFormat')) !== null && _getConfig !== void 0 ? _getConfig : 'lll';
  model.series.forEach(seriesModel => {
    series.filter(row => (0, _lodash.startsWith)(row.id, seriesModel.id)).forEach(row => {
      let label = (0, _empty_label.getValueOrEmpty)(row.label);
      if (label !== _empty_label.emptyLabel) {
        label = (0, _lodash.snakeCase)(label);
      }

      // label might be not purely alphanumeric, wrap in brackets to map sure it's resolved correctly
      const varName = [`[${label}]`, (0, _lodash.snakeCase)(seriesModel.var_name)].filter(v => v).join('.');
      const formatter = seriesModel.formatter === _enums.DATA_FORMATTERS.DEFAULT ? (0, _create_field_formatter.createFieldFormatter)((0, _get_metrics_field.getMetricsField)(seriesModel.metrics), fieldFormatMap) : (0, _tick_formatter.createTickFormatter)(seriesModel.formatter, seriesModel.value_template, getConfig);
      const lastValue = (0, _last_value_utils.getLastValue)(row.data);
      const data = {
        last: {
          raw: lastValue,
          formatted: formatter(lastValue)
        },
        data: {
          raw: row.data,
          formatted: row.data.map(point => {
            return [(0, _moment.default)(point[0]).format(dateFormat), formatter(point[1])];
          })
        }
      };
      let rowLabel = row.label;
      if (seriesModel.split_mode === _enums.BUCKET_TYPES.TERMS) {
        const fieldsForTerms = (0, _fields_utils.getFieldsForTerms)(seriesModel.terms_field);
        if (fieldsForTerms.length === 1) {
          rowLabel = (0, _create_field_formatter.createFieldFormatter)(fieldsForTerms[0], fieldFormatMap, undefined, false, dataView)(row.label);
        }
      }
      (0, _saferLodashSet.set)(variables, varName, data);
      // label might be not purely alphanumeric, wrap in brackets to map sure it's resolved correctly
      (0, _saferLodashSet.set)(variables, `[${label}].label`, rowLabel);
      // compatibility
      (0, _saferLodashSet.set)(variables, `[${label}].formatted`, rowLabel);
    });
  });
  return variables;
};
exports.convertSeriesToVars = convertSeriesToVars;