"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _agg_select = require("./agg_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _common = require("../../styles/common.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function SeriesAggUi(props) {
  const {
    panel,
    model,
    intl
  } = props;
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const functionOptions = [{
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.sumLabel',
      defaultMessage: 'Sum'
    }),
    value: 'sum'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.maxLabel',
      defaultMessage: 'Max'
    }),
    value: 'max'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.minLabel',
      defaultMessage: 'Min'
    }),
    value: 'min'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.avgLabel',
      defaultMessage: 'Avg'
    }),
    value: 'mean'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.countLabel',
      defaultMessage: 'Series count'
    }),
    value: 'count'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.overallSumLabel',
      defaultMessage: 'Overall Sum'
    }),
    value: 'overall_sum'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.overallMaxLabel',
      defaultMessage: 'Overall Max'
    }),
    value: 'overall_max'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.overallMinLabel',
      defaultMessage: 'Overall Min'
    }),
    value: 'overall_min'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.overallAvgLabel',
      defaultMessage: 'Overall Avg'
    }),
    value: 'overall_avg'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.seriesAgg.functionOptions.cumulativeSumLabel',
      defaultMessage: 'Cumulative Sum'
    }),
    value: 'cumulative_sum'
  }];
  const selectedFunctionOption = functionOptions.find(option => {
    return model.function === option.value;
  });
  if (panel.type === 'table') {
    return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
      disableDelete: props.disableDelete,
      model: props.model,
      onAdd: props.onAdd,
      onDelete: props.onDelete,
      siblings: props.siblings,
      dragHandleProps: props.dragHandleProps
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs",
      css: (0, _common.titleStyles)(euiTheme)
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesAgg.seriesAggIsNotCompatibleLabel",
      defaultMessage: "Series Agg is not compatible with the table visualization."
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.seriesAgg.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('function'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesAgg.functionLabel",
      defaultMessage: "Function"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: functionOptions,
    selectedOptions: selectedFunctionOption ? [selectedFunctionOption] : [],
    onChange: handleSelectChange('function'),
    singleSelection: {
      asPlainText: true
    }
  })))));
}
SeriesAggUi.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};
const SeriesAgg = exports.SeriesAgg = (0, _i18nReact.injectI18n)(SeriesAggUi);