"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StylePanel = StylePanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _collections = require("../../collections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const gaugeCollections = (0, _collections.getGaugeCollections)();
function StylePanel({
  aggs,
  setGaugeValue,
  stateParams,
  showElasticChartsOptions
}) {
  const disableAlignment = aggs.byType(_public2.AggGroupNames.Metrics).length === 1 && !aggs.byType(_public2.AggGroupNames.Buckets);
  const alignmentSelect = /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    disabled: showElasticChartsOptions || disableAlignment,
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.alignmentLabel', {
      defaultMessage: 'Alignment'
    }),
    options: gaugeCollections.alignments,
    paramName: "alignment",
    value: stateParams.gauge.alignment,
    setValue: setGaugeValue
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeGauge.controls.gaugeOptions.styleTitle",
    defaultMessage: "Style"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.gaugeTypeLabel', {
      defaultMessage: 'Gauge type'
    }),
    options: gaugeCollections.gaugeTypes,
    paramName: "gaugeType",
    value: stateParams.gauge.gaugeType,
    setValue: setGaugeValue
  }), showElasticChartsOptions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('visTypeGauge.editors.gauge.alignmentNotAvailable', {
      defaultMessage: 'The alignment is not yet supported with the new charts library. Please, enable the gauge legacy charts library advanced setting.'
    }),
    delay: "long",
    position: "right"
  }, alignmentSelect), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : alignmentSelect);
}