"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadiusRatioOptionControl = RadiusRatioOptionControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_VALUE = 50;
const PARAM_NAME = 'radiusRatio';
function RadiusRatioOptionControl({
  editorStateParams,
  setStateParamValue
}) {
  const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.dotSizeRatioLabel",
    defaultMessage: "Dot size ratio"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visDefaultEditor.controls.dotSizeRatioHelpText', {
      defaultMessage: 'Change the ratio of the radius of the smallest point to the largest point.'
    }),
    position: "right"
  }));
  (0, _useMount.default)(() => {
    if (!editorStateParams.radiusRatio) {
      setStateParamValue(PARAM_NAME, DEFAULT_VALUE);
    }
  });
  const onChange = (0, _react.useCallback)(e => setStateParamValue(PARAM_NAME, parseFloat(e.currentTarget.value)), [setStateParamValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    min: 1,
    max: 100,
    value: editorStateParams.radiusRatio || DEFAULT_VALUE,
    onChange: onChange,
    showRange: true,
    showValue: true,
    valueAppend: "%"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}