"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherBucketParamEditor = OtherBucketParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _switch = require("./switch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function OtherBucketParamEditor(props) {
  return /*#__PURE__*/_react.default.createElement(_switch.SwitchParamEditor, (0, _extends2.default)({
    dataTestSubj: "otherBucketSwitch",
    displayLabel: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.groupValuesLabel', {
      defaultMessage: 'Group other values in separate bucket'
    }),
    displayToolTip: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.groupValuesTooltip', {
      defaultMessage: 'Values not in the top N are grouped in this bucket. ' + "To include documents with missing values, enable 'Show missing values'."
    })
  }, props));
}