"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakdownFilter = BreakdownFilter;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BreakdownFilter({
  selectedBreakdown,
  onBreakdownChange,
  dataTestSubj
}) {
  var _selectedBreakdown$fi;
  const NO_BREAKDOWN = 'noBreakdown';
  const items = [{
    name: _i18n.i18n.translate('xpack.ux.breakDownFilter.noBreakdown', {
      defaultMessage: 'No breakdown'
    }),
    fieldName: NO_BREAKDOWN,
    type: 'category'
  }, {
    name: _i18n.i18n.translate('xpack.ux.breakdownFilter.browser', {
      defaultMessage: 'Browser'
    }),
    fieldName: _elasticsearch_fieldnames.USER_AGENT_NAME,
    type: 'category'
  }, {
    name: _i18n.i18n.translate('xpack.ux.breakdownFilter.os', {
      defaultMessage: 'OS'
    }),
    fieldName: _elasticsearch_fieldnames.USER_AGENT_OS,
    type: 'category'
  }, {
    name: _i18n.i18n.translate('xpack.ux.breakdownFilter.device', {
      defaultMessage: 'Device'
    }),
    fieldName: _elasticsearch_fieldnames.USER_AGENT_DEVICE,
    type: 'category'
  }, {
    name: _i18n.i18n.translate('xpack.ux.breakdownFilter.location', {
      defaultMessage: 'Location'
    }),
    fieldName: _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_ISO_CODE,
    type: 'category'
  }];
  const options = items.map(({
    name,
    fieldName
  }) => ({
    inputDisplay: fieldName === NO_BREAKDOWN ? name : /*#__PURE__*/_react.default.createElement("strong", null, name),
    value: fieldName,
    dropdownDisplay: name
  }));
  const onOptionChange = value => {
    if (value === NO_BREAKDOWN) {
      onBreakdownChange(null);
    } else {
      onBreakdownChange(items.find(({
        fieldName
      }) => fieldName === value));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    compressed: true,
    options: options,
    valueOfSelected: (_selectedBreakdown$fi = selectedBreakdown === null || selectedBreakdown === void 0 ? void 0 : selectedBreakdown.fieldName) !== null && _selectedBreakdown$fi !== void 0 ? _selectedBreakdown$fi : NO_BREAKDOWN,
    onChange: value => onOptionChange(value),
    "data-test-subj": dataTestSubj
  });
}