"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsageCounter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Usage Counter allows to keep track of any events that occur.
 * By calling {@link IUsageCounter.incrementCounter} devs can notify this
 * API whenever the event happens.
 */

class UsageCounter {
  constructor({
    domainId,
    counter$,
    retentionPeriodDays
  }) {
    (0, _defineProperty2.default)(this, "domainId", void 0);
    (0, _defineProperty2.default)(this, "counter$", void 0);
    (0, _defineProperty2.default)(this, "retentionPeriodDays", void 0);
    (0, _defineProperty2.default)(this, "incrementCounter", params => {
      const {
        counterName,
        counterType = 'count',
        source = 'server',
        // default behavior before introducing the property
        incrementBy = 1,
        namespace
      } = params;
      this.counter$.next({
        domainId: this.domainId,
        counterName,
        counterType,
        source,
        incrementBy,
        ...(namespace && {
          namespace
        })
      });
    });
    this.domainId = domainId;
    this.counter$ = counter$;
    this.retentionPeriodDays = retentionPeriodDays;
  }
}
exports.UsageCounter = UsageCounter;