"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DurationAnomalyAlert;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _state = require("../../../state");
var _anomaly_alert = require("../../../components/overview/alerts/anomaly_alert/anomaly_alert");
var _kibana_service = require("../../../state/kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function DurationAnomalyAlert({
  core,
  plugins,
  params,
  stackVersion
}) {
  _kibana_service.kibanaService.core = core;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_alert.AnomalyAlertComponent, (0, _extends2.default)({}, params, {
    stackVersion: stackVersion
  }))));
}
module.exports = exports.default;