"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallBarChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _chartsTheme = require("@kbn/charts-theme");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _constants = require("./constants");
var _styles = require("./styles");
var _ = require("..");
var _waterfall_tooltip_content = require("./waterfall_tooltip_content");
var _data_formatting = require("../../step_detail/waterfall/data_formatting");
var _waterfall_markers = require("./waterfall_markers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChartHeight = data => {
  // We get the last item x(number of bars) and adds 1 to cater for 0 index
  const noOfXBars = new Set(data.map(item => item.x)).size;
  return noOfXBars * _constants.BAR_HEIGHT;
};
const CustomTooltip = tooltipInfo => {
  var _tooltipInfo$header3;
  const {
    data,
    sidebarItems
  } = (0, _.useWaterfallContext)();
  return (0, _react.useMemo)(() => {
    const sidebarItem = sidebarItems === null || sidebarItems === void 0 ? void 0 : sidebarItems.find(item => {
      var _tooltipInfo$header;
      return item.index === ((_tooltipInfo$header = tooltipInfo.header) === null || _tooltipInfo$header === void 0 ? void 0 : _tooltipInfo$header.value);
    });
    const relevantItems = data.filter(item => {
      var _tooltipInfo$header2;
      return item.x === ((_tooltipInfo$header2 = tooltipInfo.header) === null || _tooltipInfo$header2 === void 0 ? void 0 : _tooltipInfo$header2.value) && item.config.showTooltip && item.config.tooltipProps;
    });
    return relevantItems.length ? /*#__PURE__*/_react.default.createElement(_charts.TooltipContainer, null, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTooltip, null, sidebarItem && /*#__PURE__*/_react.default.createElement(_waterfall_tooltip_content.WaterfallTooltipContent, {
      text: (0, _data_formatting.formatTooltipHeading)(sidebarItem.index + 1, sidebarItem.url),
      url: sidebarItem.url
    }))) : null;
  }, [data, sidebarItems, (_tooltipInfo$header3 = tooltipInfo.header) === null || _tooltipInfo$header3 === void 0 ? void 0 : _tooltipInfo$header3.value]);
};
const WaterfallBarChart = ({
  chartData,
  tickFormat,
  domain,
  barStyleAccessor,
  index
}) => {
  const baseChartTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    onElementClick,
    onProjectionClick
  } = (0, _.useWaterfallContext)();
  const handleElementClick = (0, _react.useMemo)(() => onElementClick, [onElementClick]);
  const handleProjectionClick = (0, _react.useMemo)(() => onProjectionClick, [onProjectionClick]);
  const memoizedTickFormat = (0, _react.useCallback)(tickFormat, [tickFormat]);
  const appFixedViewport = (0, _coreRenderingBrowser.useAppFixedViewport)();
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartChartContainer, {
    height: getChartHeight(chartData),
    chartIndex: index,
    "data-test-subj": "wfDataOnlyBarChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    className: "data-chart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip
  // this is done to prevent the waterfall tooltip from rendering behind Kibana's
  // stacked header when the user highlights an item at the top of the chart
  , {
    boundary: appFixedViewport,
    customTooltip: CustomTooltip
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    baseTheme: baseChartTheme,
    onProjectionClick: handleProjectionClick,
    onElementClick: handleElementClick,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    "aria-hidden": true,
    id: "time",
    position: _charts.Position.Top,
    tickFormat: memoizedTickFormat,
    domain: domain,
    gridLine: {
      visible: true
    },
    style: {
      axisLine: {
        visible: false
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "waterfallItems",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    y0Accessors: ['y0'],
    styleAccessor: barStyleAccessor,
    data: chartData
  }), /*#__PURE__*/_react.default.createElement(_waterfall_markers.WaterfallChartMarkers, null)));
};
exports.WaterfallBarChart = WaterfallBarChart;