"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpgradeType = void 0;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @param {SemVer} current kibana version
 * @param {string} target version to upgrade to, defaults to next major
 * @returns {semver.ReleaseType | null | undefined} null if same version, undefined if target version is out of bounds
 */
const getUpgradeType = ({
  current,
  target
}) => {
  const targetVersion = _semver.default.coerce(target);
  const versionDiff = targetVersion.major - current.major;
  if (versionDiff > 1 || versionDiff < 0) {
    return;
  }
  return _semver.default.diff(current, _semver.default.coerce(target));
};
exports.getUpgradeType = getUpgradeType;