"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEnterpriseSearchDeprecationRoutes = registerEnterpriseSearchDeprecationRoutes;
var _pre_eight_index_deprecator = require("./pre_eight_index_deprecator");
var _es_version_precheck = require("../es_version_precheck");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerEnterpriseSearchDeprecationRoutes({
  router
}) {
  router.post({
    path: '/internal/enterprise_search/deprecations/set_enterprise_search_indices_read_only',
    validate: {}
  }, (0, _es_version_precheck.versionCheckHandlerWrapper)(async ({
    core
  }, request, response) => {
    const {
      client
    } = (await core).elasticsearch;
    const setResponse = await (0, _pre_eight_index_deprecator.setPreEightEnterpriseSearchIndicesReadOnly)(client.asCurrentUser);
    if (setResponse.length > 0) {
      return response.badRequest({
        body: {
          message: setResponse
        },
        headers: {
          'content-type': 'application/json'
        }
      });
    }
    return response.ok({
      body: {
        acknowedged: true
      },
      headers: {
        'content-type': 'application/json'
      }
    });
  }));
}