"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiMetricService = exports.UiMetricService = exports.UIM_RESET_LOGS_COUNTER_CLICK = exports.UIM_REINDEX_UNFREEZE_RETRY_CLICK = exports.UIM_REINDEX_UNFREEZE_CLICK = exports.UIM_REINDEX_STOP_CLICK = exports.UIM_REINDEX_START_CLICK = exports.UIM_REINDEX_READONLY_RETRY_CLICK = exports.UIM_REINDEX_READONLY_CLICK = exports.UIM_REINDEX_OPEN_MODAL_CLICK = exports.UIM_REINDEX_OPEN_FLYOUT_CLICK = exports.UIM_REINDEX_DELETE_RETRY_CLICK = exports.UIM_REINDEX_DELETE_CLICK = exports.UIM_REINDEX_CLOSE_MODAL_CLICK = exports.UIM_REINDEX_CLOSE_FLYOUT_CLICK = exports.UIM_OVERVIEW_PAGE_LOAD = exports.UIM_OBSERVABILITY_CLICK = exports.UIM_ML_SNAPSHOT_UPGRADE_CLICK = exports.UIM_ML_SNAPSHOT_DELETE_CLICK = exports.UIM_KIBANA_QUICK_RESOLVE_CLICK = exports.UIM_KIBANA_DEPRECATIONS_PAGE_LOAD = exports.UIM_INDEX_SETTINGS_DELETE_CLICK = exports.UIM_ES_DEPRECATION_LOGS_PAGE_LOAD = exports.UIM_ES_DEPRECATIONS_PAGE_LOAD = exports.UIM_DISCOVER_CLICK = exports.UIM_DATA_STREAM_STOP_READONLY_CLICK = exports.UIM_DATA_STREAM_START_READONLY_CLICK = exports.UIM_DATA_STREAM_REINDEX_STOP_CLICK = exports.UIM_DATA_STREAM_REINDEX_START_CLICK = exports.UIM_DATA_STREAM_REINDEX_OPEN_MODAL_CLICK = exports.UIM_DATA_STREAM_REINDEX_OPEN_FLYOUT_CLICK = exports.UIM_DATA_STREAM_REINDEX_CLOSE_MODAL_CLICK = exports.UIM_DATA_STREAM_REINDEX_CLOSE_FLYOUT_CLICK = exports.UIM_CLUSTER_SETTINGS_DELETE_CLICK = exports.UIM_BACKUP_DATA_ON_PREM_CLICK = exports.UIM_BACKUP_DATA_CLOUD_CLICK = exports.UIM_APP_NAME = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UIM_APP_NAME = exports.UIM_APP_NAME = 'upgrade_assistant';
const UIM_ES_DEPRECATIONS_PAGE_LOAD = exports.UIM_ES_DEPRECATIONS_PAGE_LOAD = 'es_deprecations_page_load';
const UIM_KIBANA_DEPRECATIONS_PAGE_LOAD = exports.UIM_KIBANA_DEPRECATIONS_PAGE_LOAD = 'kibana_deprecations_page_load';
const UIM_OVERVIEW_PAGE_LOAD = exports.UIM_OVERVIEW_PAGE_LOAD = 'overview_page_load';
const UIM_ES_DEPRECATION_LOGS_PAGE_LOAD = exports.UIM_ES_DEPRECATION_LOGS_PAGE_LOAD = 'es_deprecation_logs_page_load';

// Reindexing
const UIM_REINDEX_OPEN_FLYOUT_CLICK = exports.UIM_REINDEX_OPEN_FLYOUT_CLICK = 'reindex_open_flyout_click';
const UIM_REINDEX_CLOSE_FLYOUT_CLICK = exports.UIM_REINDEX_CLOSE_FLYOUT_CLICK = 'reindex_close_flyout_click';
const UIM_REINDEX_OPEN_MODAL_CLICK = exports.UIM_REINDEX_OPEN_MODAL_CLICK = 'reindex_open_modal_click';
const UIM_REINDEX_CLOSE_MODAL_CLICK = exports.UIM_REINDEX_CLOSE_MODAL_CLICK = 'reindex_close_modal_click';
const UIM_REINDEX_START_CLICK = exports.UIM_REINDEX_START_CLICK = 'reindex_start_click';
const UIM_REINDEX_STOP_CLICK = exports.UIM_REINDEX_STOP_CLICK = 'reindex_stop_click';
const UIM_REINDEX_READONLY_CLICK = exports.UIM_REINDEX_READONLY_CLICK = 'reindex_readonly_click';
const UIM_REINDEX_UNFREEZE_CLICK = exports.UIM_REINDEX_UNFREEZE_CLICK = 'reindex_unfreeze_click';
const UIM_REINDEX_READONLY_RETRY_CLICK = exports.UIM_REINDEX_READONLY_RETRY_CLICK = 'reindex_readonly_retry_click';
const UIM_REINDEX_UNFREEZE_RETRY_CLICK = exports.UIM_REINDEX_UNFREEZE_RETRY_CLICK = 'reindex_unfreeze_retry_click';
const UIM_REINDEX_DELETE_CLICK = exports.UIM_REINDEX_DELETE_CLICK = 'reindex_delete_click';
const UIM_REINDEX_DELETE_RETRY_CLICK = exports.UIM_REINDEX_DELETE_RETRY_CLICK = 'reindex_delete_retry_click';

// Data Streams Reindexing
const UIM_DATA_STREAM_REINDEX_OPEN_FLYOUT_CLICK = exports.UIM_DATA_STREAM_REINDEX_OPEN_FLYOUT_CLICK = 'data_stream_reindex_open_flyout_click';
const UIM_DATA_STREAM_REINDEX_CLOSE_FLYOUT_CLICK = exports.UIM_DATA_STREAM_REINDEX_CLOSE_FLYOUT_CLICK = 'data_stream_reindex_close_flyout_click';
const UIM_DATA_STREAM_REINDEX_OPEN_MODAL_CLICK = exports.UIM_DATA_STREAM_REINDEX_OPEN_MODAL_CLICK = 'data_stream_reindex_open_modal_click';
const UIM_DATA_STREAM_REINDEX_CLOSE_MODAL_CLICK = exports.UIM_DATA_STREAM_REINDEX_CLOSE_MODAL_CLICK = 'data_stream_reindex_close_modal_click';
const UIM_DATA_STREAM_REINDEX_START_CLICK = exports.UIM_DATA_STREAM_REINDEX_START_CLICK = 'data_stream_reindex_start_click';
const UIM_DATA_STREAM_REINDEX_STOP_CLICK = exports.UIM_DATA_STREAM_REINDEX_STOP_CLICK = 'data_stream_reindex_stop_click';
const UIM_DATA_STREAM_START_READONLY_CLICK = exports.UIM_DATA_STREAM_START_READONLY_CLICK = 'data_stream_readonly_start_click';
const UIM_DATA_STREAM_STOP_READONLY_CLICK = exports.UIM_DATA_STREAM_STOP_READONLY_CLICK = 'data_stream_readonly_stop_click';
const UIM_BACKUP_DATA_CLOUD_CLICK = exports.UIM_BACKUP_DATA_CLOUD_CLICK = 'backup_data_cloud_click';
const UIM_BACKUP_DATA_ON_PREM_CLICK = exports.UIM_BACKUP_DATA_ON_PREM_CLICK = 'backup_data_on_prem_click';
const UIM_RESET_LOGS_COUNTER_CLICK = exports.UIM_RESET_LOGS_COUNTER_CLICK = 'reset_logs_counter_click';
const UIM_OBSERVABILITY_CLICK = exports.UIM_OBSERVABILITY_CLICK = 'observability_click';
const UIM_DISCOVER_CLICK = exports.UIM_DISCOVER_CLICK = 'discover_click';
const UIM_ML_SNAPSHOT_UPGRADE_CLICK = exports.UIM_ML_SNAPSHOT_UPGRADE_CLICK = 'ml_snapshot_upgrade_click';
const UIM_ML_SNAPSHOT_DELETE_CLICK = exports.UIM_ML_SNAPSHOT_DELETE_CLICK = 'ml_snapshot_delete_click';
const UIM_INDEX_SETTINGS_DELETE_CLICK = exports.UIM_INDEX_SETTINGS_DELETE_CLICK = 'index_settings_delete_click';
const UIM_KIBANA_QUICK_RESOLVE_CLICK = exports.UIM_KIBANA_QUICK_RESOLVE_CLICK = 'kibana_quick_resolve_click';
const UIM_CLUSTER_SETTINGS_DELETE_CLICK = exports.UIM_CLUSTER_SETTINGS_DELETE_CLICK = 'cluster_settings_delete_click';
class UiMetricService {
  constructor() {
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
  }
  setup(usageCollection) {
    this.usageCollection = usageCollection;
  }
  track(metricType, eventName) {
    if (!this.usageCollection) {
      // Usage collection might be disabled in Kibana config.
      return;
    }
    return this.usageCollection.reportUiCounter(UIM_APP_NAME, metricType, eventName);
  }
  trackUiMetric(metricType, eventName) {
    return this.track(metricType, eventName);
  }
}
exports.UiMetricService = UiMetricService;
const uiMetricService = exports.uiMetricService = new UiMetricService();