"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamReindexResolutionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../common/types");
var _utils = require("../../../../lib/utils");
var _types2 = require("../../../types");
var _context = require("./context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getI18nTexts = resolutionType => {
  return {
    loadingStatusText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionLoadingStatusText', {
      defaultMessage: 'Loading status…'
    }),
    resolutionInProgressText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionInProgressText', {
      defaultMessage: '{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} in progress…',
      values: {
        resolutionType
      }
    }),
    resolutionCompleteText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionCompleteText', {
      defaultMessage: '{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} complete',
      values: {
        resolutionType
      }
    }),
    resolutionFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resulutionFailedText', {
      defaultMessage: '{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} failed',
      values: {
        resolutionType
      }
    }),
    resolutionFetchFailedText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionFetchFailedText', {
      defaultMessage: '{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} status not available',
      values: {
        resolutionType
      }
    }),
    reindexCanceledText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.resolutionCanceledText', {
      defaultMessage: '{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} cancelled',
      values: {
        resolutionType
      }
    }),
    recommendedActionTexts: {
      readonly: {
        text: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.recommendedActionReadonlyText', {
          defaultMessage: 'Recommended: set to read-only'
        }),
        tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.recommendedActionReadonlyTooltipText', {
          defaultMessage: 'If you do not need to update historical data, set it to read-only. You can reindex post-upgrade if updates are needed.'
        })
      },
      reindex: {
        text: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.recommendedActionReindexText', {
          defaultMessage: 'Recommended: reindex'
        }),
        tooltipText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.dataStream.recommendedActionReindexTooltipText', {
          defaultMessage: 'The current write index will be rolled over and reindexed. Additional backing indices will be reindexed and remain editable.'
        })
      }
    }
  };
};
const DataStreamReindexResolutionCell = ({
  correctiveAction
}) => {
  var _correctiveAction$met;
  const {
    migrationState
  } = (0, _context.useDataStreamMigrationContext)();
  const i18nTexts = getI18nTexts(migrationState.resolutionType);

  // The suggested option for data streams by default is always 'readonly' unless is excluded from the corrective action.
  const recommendedAction = (_correctiveAction$met = correctiveAction.metadata.excludedActions) !== null && _correctiveAction$met !== void 0 && _correctiveAction$met.includes('readOnly') ? 'reindex' : 'readonly';
  if (migrationState.loadingState === _types2.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("em", null, i18nTexts.loadingStatusText))));
  }
  switch (migrationState.status) {
    case _types.DataStreamMigrationStatus.inProgress:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("em", null, i18nTexts.resolutionInProgressText, ' ', (0, _utils.getDataStreamReindexProgressLabel)(migrationState.status, migrationState.taskPercComplete)))));
    case _types.DataStreamMigrationStatus.completed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "checkInCircleFilled",
        color: "success"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.resolutionCompleteText)));
    case _types.DataStreamMigrationStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warningFilled",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.resolutionFailedText)));
    case _types.DataStreamMigrationStatus.fetchFailed:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warningFilled",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, i18nTexts.resolutionFetchFailedText)));
    default:
      if (recommendedAction) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("em", null, i18nTexts.recommendedActionTexts[recommendedAction].text, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          content: i18nTexts.recommendedActionTexts[recommendedAction].tooltipText
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "info",
          "aria-label": i18nTexts.recommendedActionTexts[recommendedAction].tooltipText,
          size: "s"
        }))));
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.DataStreamReindexResolutionCell = DataStreamReindexResolutionCell;