"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationClarificationCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DurationClarificationCallOut = ({
  formattedDate,
  learnMoreUrl
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "dataStreamMigrationWarningsCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.indicesNeedReindexing",
    defaultMessage: "Indices created on or before {formattedDate} need to be reindexed to a compatible format or set to read-only.",
    values: {
      formattedDate
    }
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.backingIndicesUnfrozen",
    defaultMessage: "If any of the backing indices of the data stream are frozen, they will be converted to non-frozen indices during the update process."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.suggestReadOnly",
    defaultMessage: "Depending on size and resources, reindexing may take extended time and your data will be in a read-only state until the job has completed. {learnMoreHtml}",
    values: {
      learnMoreHtml: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: learnMoreUrl,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.learnMoreLink",
        defaultMessage: "Learn more"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.DurationClarificationCallOut = DurationClarificationCallOut;