"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationProgress = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _types = require("../../../../../../../../../common/types");
var _utils = require("../../../../../../../lib/utils");
var _progress_title = require("./progress_title");
var _types2 = require("../../../../../../types");
var _step_progress = require("../../../../../common/step_progress");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays a list of steps in the reindex operation, the current status, a progress bar,
 * and any error messages that are encountered.
 */
const MigrationProgress = props => {
  const {
    dataStreamName,
    migrationState: {
      status,
      taskPercComplete,
      cancelLoadingState,
      taskStatus,
      resolutionType
    }
  } = props;

  // The reindexing step is special because it generally lasts longer and can be cancelled mid-flight
  const reindexingDocsStep = {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_progress_title.MigrateDocumentsStepTitle, props)))
  };
  const inProgress = status === _types.DataStreamMigrationStatus.inProgress || status === _types.DataStreamMigrationStatus.completed;
  let euiProgressColor = 'subdued';
  if (cancelLoadingState === _types2.CancelLoadingState.Error) {
    reindexingDocsStep.status = 'failed';
    euiProgressColor = 'danger';
  } else if (cancelLoadingState === _types2.CancelLoadingState.Loading || cancelLoadingState === _types2.CancelLoadingState.Requested) {
    reindexingDocsStep.status = 'inProgress';
    euiProgressColor = 'subdued';
  } else if (status === _types.DataStreamMigrationStatus.failed) {
    reindexingDocsStep.status = 'failed';
    euiProgressColor = 'danger';
  } else if (status === _types.DataStreamMigrationStatus.cancelled || cancelLoadingState === _types2.CancelLoadingState.Success) {
    reindexingDocsStep.status = 'cancelled';
  } else if (status === undefined) {
    reindexingDocsStep.status = 'incomplete';
    euiProgressColor = 'subdued';
  } else if (status === _types.DataStreamMigrationStatus.inProgress) {
    reindexingDocsStep.status = 'inProgress';
    euiProgressColor = 'primary';
  } else if (status === _types.DataStreamMigrationStatus.completed) {
    reindexingDocsStep.status = 'complete';
    euiProgressColor = 'success';
  } else {
    // not started // undefined
    reindexingDocsStep.status = 'incomplete';
    euiProgressColor = 'subdued';
  }
  const progressPercentage = inProgress ? (0, _utils.getDataStreamReindexProgress)(status, taskPercComplete) : undefined;
  const showProgressValueText = inProgress;
  const progressMaxValue = inProgress ? 100 : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "reindexChecklistTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, status === _types.DataStreamMigrationStatus.inProgress ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingInProgressTitle",
    defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} delete {Deleting} other {Migration}} {dataStreamName} in progress\u2026",
    values: {
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStreamName)
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklistTitle",
    defaultMessage: "{resolutionType, select, reindex {Reindex {dataStreamName}} readonly {Set {dataStreamName} to read-only} delete {Delete {dataStreamName}} other {Migrate data stream}}",
    values: {
      resolutionType,
      dataStreamName: dataStreamName && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStreamName)
    }
  })))), resolutionType !== 'delete' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    label: taskStatus ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingInProgressTitle",
      defaultMessage: "Started {startTimeFromNow}",
      values: {
        startTimeFromNow: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelativeTime, {
          value: (taskStatus.startTimeMs - +(0, _moment.default)()) / 1000,
          updateIntervalInSeconds: 1
        })
      }
    }) : undefined,
    valueText: showProgressValueText,
    value: progressPercentage,
    max: progressMaxValue,
    color: euiProgressColor,
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_step_progress.StepProgress, {
    steps: [reindexingDocsStep]
  })), inProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !taskStatus && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.fetchingStatus",
    defaultMessage: "Fetching Status\u2026"
  })), taskStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    style: {
      padding: '0 28px'
    }
  }, taskStatus.errorsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.failedTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} failed to get {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.errorsCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "success"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.completeTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} successfully {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.successCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.inProgressTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} currently getting {resolutionType, select, reindex {reindexed} readonly {set to read-only} other {migrated}}.',
    values: {
      count: taskStatus.inProgressCount,
      resolutionType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.progressStep.pendingTitle', {
    defaultMessage: '{count, plural, =1 {# Index} other {# Indices}} waiting to start.',
    values: {
      count: taskStatus.pendingCount
    }
  }))))))));
};
exports.MigrationProgress = MigrationProgress;