"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populateStateFromSavedQuery = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const populateStateFromSavedQuery = (queryService, savedQuery) => {
  const {
    timefilter: {
      timefilter
    },
    filterManager,
    queryString
  } = queryService;
  // timefilter
  if (savedQuery.attributes.timefilter) {
    timefilter.setTime({
      from: savedQuery.attributes.timefilter.from,
      to: savedQuery.attributes.timefilter.to
    });
    if (savedQuery.attributes.timefilter.refreshInterval) {
      timefilter.setRefreshInterval(savedQuery.attributes.timefilter.refreshInterval);
    }
  }

  // query string
  queryString.setQuery(savedQuery.attributes.query);

  // filters
  const savedQueryFilters = savedQuery.attributes.filters || [];
  const globalFilters = filterManager.getGlobalFilters();
  filterManager.setFilters([...globalFilters, ...savedQueryFilters]);
};
exports.populateStateFromSavedQuery = populateStateFromSavedQuery;