"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.QueryLanguageSwitcher = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const strings = exports.strings = {
  getSwitchLanguageButtonText: () => _i18n.i18n.translate('unifiedSearch.switchLanguage.buttonText', {
    defaultMessage: 'Switch language button.'
  })
};
const QueryLanguageSwitcher = exports.QueryLanguageSwitcher = /*#__PURE__*/_react.default.memo(function QueryLanguageSwitcher({
  language,
  anchorPosition,
  onSelectLanguage,
  nonKqlMode = 'lucene',
  isOnTopBarMenu,
  isDisabled,
  deps: {
    docLinks
  }
}) {
  const kueryQuerySyntaxDocs = docLinks.links.query.kueryQuerySyntax;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "m",
    iconType: "filter",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    className: "kqlQueryBar__languageSwitcherButton",
    "data-test-subj": 'switchQueryLanguageButton',
    "aria-label": strings.getSwitchLanguageButtonText(),
    disabled: isDisabled
  });
  const languageMenuItem = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "KQL",
    icon: language === 'kuery' ? 'check' : 'empty',
    "data-test-subj": "kqlLanguageMenuItem",
    onClick: () => {
      onSelectLanguage('kuery');
    }
  }, "KQL"), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: nonKqlMode,
    icon: language === 'kuery' ? 'empty' : 'check',
    "data-test-subj": "luceneLanguageMenuItem",
    onClick: () => {
      onSelectLanguage(nonKqlMode);
    }
  }, (0, _eui.toSentenceCase)(nonKqlMode)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: 'documentation',
    icon: 'documentation',
    href: kueryQuerySyntaxDocs,
    target: "_blank"
  }, "Documentation"));
  const languageQueryStringComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "queryLanguageSwitcherPopover",
    anchorPosition: anchorPosition || 'downLeft',
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    repositionOnScroll: true,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedSearch.query.queryBar.syntaxOptionsTitle",
    defaultMessage: "Syntax options"
  })), languageMenuItem);
  return Boolean(isOnTopBarMenu) ? languageMenuItem : languageQueryStringComponent;
});