"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItem = exports.FILTER_EDITOR_WIDTH = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./filter_item.scss");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _public = require("@kbn/data-plugin/public");
var _filter_editor = require("../filter_editor/filter_editor");
var _filter_view = require("../filter_view");
var _filter_editor2 = require("../filter_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FILTER_ITEM_OK = '';
const FILTER_ITEM_WARNING = 'warn';
const FILTER_ITEM_ERROR = 'error';
const FILTER_EDITOR_WIDTH = exports.FILTER_EDITOR_WIDTH = 1200;
function FilterItemComponent(props) {
  const {
    onCloseFilterPopover,
    onLocalFilterCreate,
    onLocalFilterUpdate
  } = props;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [renderedComponent, setRenderedComponent] = (0, _react.useState)('menu');
  const {
    id,
    filter,
    indexPatterns,
    hiddenPanelOptions,
    readOnly = false,
    docLinks
  } = props;
  const closePopover = (0, _react.useCallback)(() => {
    onCloseFilterPopover([() => setIsPopoverOpen(false)]);
  }, [onCloseFilterPopover]);
  const euiTheme = (0, _eui.useEuiTheme)();

  /** @todo important style should be remove after fixing elastic/eui/issues/6314. */
  const popoverDragAndDropStyle = (0, _react.useMemo)(() => (0, _react2.css)`
        // Always needed for popover with drag & drop in them
        transform: none !important;
        transition: none !important;
        filter: none !important;
        ${(0, _eui.euiShadowMedium)(euiTheme)}
      `, [euiTheme]);
  (0, _react.useEffect)(() => {
    if (isPopoverOpen) {
      setRenderedComponent('menu');
    }
  }, [isPopoverOpen]);
  function handleBadgeClick(e) {
    if (e.shiftKey) {
      onToggleDisabled();
    } else {
      setIsPopoverOpen(!isPopoverOpen);
    }
  }
  function handleIconClick() {
    props.onRemove();
    setIsPopoverOpen(false);
  }
  function onSubmit(f) {
    setIsPopoverOpen(false);
    props.onUpdate(f);
  }
  function onTogglePinned() {
    const f = (0, _esQuery.toggleFilterPinned)(filter);
    props.onUpdate(f);
  }
  function onToggleNegated() {
    const f = (0, _esQuery.toggleFilterNegated)(filter);
    props.onUpdate(f);
  }
  function onToggleDisabled() {
    const f = (0, _esQuery.toggleFilterDisabled)(filter);
    props.onUpdate(f);
  }
  function isValidLabel(labelConfig) {
    return labelConfig.status === FILTER_ITEM_OK;
  }
  function isDisabled(labelConfig) {
    const {
      disabled
    } = filter.meta;
    return disabled || labelConfig.status === FILTER_ITEM_ERROR;
  }
  function getClasses(negate, labelConfig) {
    return (0, _classnames.default)('globalFilterItem', {
      'globalFilterItem-isDisabled': isDisabled(labelConfig),
      'globalFilterItem-isError': labelConfig.status === FILTER_ITEM_ERROR,
      'globalFilterItem-isWarning': labelConfig.status === FILTER_ITEM_WARNING,
      'globalFilterItem-isPinned': (0, _esQuery.isFilterPinned)(filter),
      'globalFilterItem-isExcluded': negate
    }, props.className);
  }
  function getDataTestSubj(labelConfig) {
    const dataTestSubjKey = filter.meta.key ? `filter-key-${filter.meta.key}` : '';
    const valueLabel = isValidLabel(labelConfig) ? labelConfig.title : labelConfig.status;
    const dataTestSubjValue = valueLabel ? `filter-value-${valueLabel.replace(/\s/g, '')}` : '';
    const dataTestSubjNegated = filter.meta.negate ? 'filter-negated' : '';
    const dataTestSubjDisabled = `filter-${isDisabled(labelConfig) ? 'disabled' : 'enabled'}`;
    const dataTestSubjPinned = `filter-${(0, _esQuery.isFilterPinned)(filter) ? 'pinned' : 'unpinned'}`;
    const dataTestSubjId = `filter-id-${id}`;
    return (0, _classnames.default)('filter', dataTestSubjDisabled, dataTestSubjKey, dataTestSubjValue, dataTestSubjPinned, dataTestSubjNegated, dataTestSubjId);
  }
  function getPanels() {
    const {
      negate,
      disabled
    } = filter.meta;
    let mainPanelItems = [{
      name: (0, _esQuery.isFilterPinned)(filter) ? props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.unpinFilterButtonLabel',
        defaultMessage: 'Unpin'
      }) : props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.pinFilterButtonLabel',
        defaultMessage: 'Pin across all apps'
      }),
      icon: 'pin',
      onClick: () => {
        setIsPopoverOpen(false);
        onTogglePinned();
      },
      'data-test-subj': 'pinFilter'
    }, {
      name: props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.editFilterButtonLabel',
        defaultMessage: 'Edit filter'
      }),
      icon: 'pencil',
      'data-test-subj': 'editFilter',
      onClick: () => {
        setRenderedComponent('editFilter');
      }
    }, {
      name: negate ? props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.includeFilterButtonLabel',
        defaultMessage: 'Include results'
      }) : props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.excludeFilterButtonLabel',
        defaultMessage: 'Exclude results'
      }),
      icon: negate ? 'plusInCircle' : 'minusInCircle',
      onClick: () => {
        setIsPopoverOpen(false);
        onToggleNegated();
      },
      'data-test-subj': 'negateFilter'
    }, {
      name: disabled ? props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.enableFilterButtonLabel',
        defaultMessage: 'Re-enable'
      }) : props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.disableFilterButtonLabel',
        defaultMessage: 'Temporarily disable'
      }),
      icon: `${disabled ? 'eye' : 'eyeClosed'}`,
      onClick: () => {
        setIsPopoverOpen(false);
        onToggleDisabled();
      },
      'data-test-subj': 'disableFilter'
    }, {
      name: props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.deleteFilterButtonLabel',
        defaultMessage: 'Delete'
      }),
      icon: 'trash',
      onClick: () => {
        setIsPopoverOpen(false);
        props.onRemove();
      },
      'data-test-subj': 'deleteFilter'
    }];
    if (hiddenPanelOptions && hiddenPanelOptions.length > 0) {
      mainPanelItems = mainPanelItems.filter(pItem => !hiddenPanelOptions.includes(pItem['data-test-subj']));
    }
    return [{
      id: 0,
      items: mainPanelItems
    }];
  }

  /**
   * Checks if filter field exists in any of the index patterns provided,
   * Because if so, a filter for the wrong index pattern may still be applied.
   * This function makes this behavior explicit, but it needs to be revised.
   */
  function isFilterApplicable() {
    var _filter$meta;
    // Any filter is applicable if no index patterns were provided to FilterBar.
    if (!props.indexPatterns.length) return true;
    const ip = (0, _public.getIndexPatternFromFilter)(filter, indexPatterns);
    if (ip) return true;
    const allFields = indexPatterns.map(indexPattern => {
      return indexPattern.fields.map(field => field.name);
    });
    const flatFields = allFields.reduce((acc, it) => [...acc, ...it], []);
    return flatFields.includes(((_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.key) || '');
  }
  function getValueLabel() {
    var _filter$meta2;
    const label = {
      title: '',
      message: '',
      status: FILTER_ITEM_OK
    };
    if ((_filter$meta2 = filter.meta) !== null && _filter$meta2 !== void 0 && _filter$meta2.isMultiIndex) {
      return label;
    }
    if (isFilterApplicable()) {
      try {
        label.title = (0, _public.getDisplayValueFromFilter)(filter, indexPatterns);
      } catch (e) {
        label.status = FILTER_ITEM_WARNING;
        label.title = props.intl.formatMessage({
          id: 'unifiedSearch.filter.filterBar.labelWarningText',
          defaultMessage: `Warning`
        });
        label.message = e.message;
      }
    } else {
      label.status = FILTER_ITEM_WARNING;
      label.title = props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.labelWarningText',
        defaultMessage: `Warning`
      });
      label.message = props.intl.formatMessage({
        id: 'unifiedSearch.filter.filterBar.labelWarningInfo',
        defaultMessage: 'Field {fieldName} does not exist in current view'
      }, {
        fieldName: filter.meta.key
      });
    }
    return label;
  }
  const valueLabelConfig = getValueLabel();

  // Disable errored filters and re-render
  if (valueLabelConfig.status === FILTER_ITEM_ERROR && !filter.meta.disabled) {
    filter.meta.disabled = true;
    props.onUpdate(filter);
    return null;
  }
  const filterViewProps = {
    filter,
    readOnly,
    valueLabel: valueLabelConfig.title,
    filterLabelStatus: valueLabelConfig.status,
    errorMessage: valueLabelConfig.message,
    className: getClasses(!!filter.meta.negate, valueLabelConfig),
    dataViews: indexPatterns,
    iconOnClick: handleIconClick,
    onClick: handleBadgeClick,
    'data-test-subj': getDataTestSubj(valueLabelConfig)
  };
  const popoverProps = {
    id: `popoverFor_filter${id}`,
    display: 'block',
    isOpen: isPopoverOpen,
    closePopover,
    button: /*#__PURE__*/_react.default.createElement(_filter_view.FilterView, filterViewProps),
    panelPaddingSize: 'none',
    panelProps: {
      css: popoverDragAndDropStyle
    }
  };
  return readOnly ? /*#__PURE__*/_react.default.createElement(_filter_view.FilterView, filterViewProps) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    anchorPosition: "downLeft"
  }, popoverProps), renderedComponent === 'menu' ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: getPanels()
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement("div", {
      css: {
        width: FILTER_EDITOR_WIDTH,
        maxWidth: '100%'
      },
      key: "filter-editor"
    }, /*#__PURE__*/_react.default.createElement(_filter_editor.FilterEditor, {
      filter: filter,
      indexPatterns: indexPatterns,
      onSubmit: onSubmit,
      onLocalFilterUpdate: onLocalFilterUpdate,
      onLocalFilterCreate: onLocalFilterCreate,
      onCancel: () => setIsPopoverOpen(false),
      timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: props.filtersForSuggestions,
      suggestionsAbstraction: props.suggestionsAbstraction,
      docLinks: docLinks,
      filtersCount: props.filtersCount,
      dataViews: props.dataViews
    }))]
  }));
}
const FilterItem = exports.FilterItem = (0, _filter_editor2.withCloseFilterEditorConfirmModal)(FilterItemComponent);