"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRequestParams = void 0;
var _common = require("@kbn/data-plugin/common");
var _react = require("react");
var _use_stable_callback = require("./use_stable_callback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useRequestParams = ({
  services,
  query: originalQuery,
  filters: originalFilters,
  timeRange: originalTimeRange
}) => {
  const {
    data
  } = services;
  const filters = (0, _react.useMemo)(() => originalFilters !== null && originalFilters !== void 0 ? originalFilters : [], [originalFilters]);
  const query = (0, _react.useMemo)(() => originalQuery !== null && originalQuery !== void 0 ? originalQuery : data.query.queryString.getDefaultQuery(), [data.query.queryString, originalQuery]);
  const relativeTimeRange = (0, _react.useMemo)(() => originalTimeRange !== null && originalTimeRange !== void 0 ? originalTimeRange : data.query.timefilter.timefilter.getTimeDefaults(), [data.query.timefilter.timefilter, originalTimeRange]);
  const timeRange = (0, _react.useRef)((0, _common.getAbsoluteTimeRange)(relativeTimeRange));
  const getTimeRange = (0, _react.useCallback)(() => timeRange.current, []);
  const updateTimeRange = (0, _use_stable_callback.useStableCallback)(() => {
    timeRange.current = (0, _common.getAbsoluteTimeRange)(relativeTimeRange);
  });
  return {
    filters,
    query,
    getTimeRange,
    updateTimeRange,
    relativeTimeRange
  };
};
exports.useRequestParams = useRequestParams;