"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildBucketInterval = void 0;
var _public = require("@kbn/data-plugin/public");
var _get_chart_agg_configs = require("./get_chart_agg_configs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Convert the response from the chart request into a format that can be used
 * by the Unified Histogram chart. The returned object should be used to update
 * time range interval of histogram.
 */
const buildBucketInterval = ({
  data,
  dataView,
  timeInterval,
  timeRange,
  response
}) => {
  var _bucketAggConfig$buck;
  if (!timeInterval || !response) {
    return {};
  }
  const chartAggConfigs = (0, _get_chart_agg_configs.getChartAggConfigs)({
    dataView,
    timeInterval,
    timeRange,
    data
  });
  const bucketAggConfig = chartAggConfigs.aggs[1];
  (0, _public.tabifyAggResponse)(chartAggConfigs, response);
  return _public.search.aggs.isDateHistogramBucketAggConfig(bucketAggConfig) ? bucketAggConfig === null || bucketAggConfig === void 0 ? void 0 : (_bucketAggConfig$buck = bucketAggConfig.buckets) === null || _bucketAggConfig$buck === void 0 ? void 0 : _bucketAggConfig$buck.getInterval() : undefined;
};
exports.buildBucketInterval = buildBucketInterval;