"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartConfigPanel = ChartConfigPanel;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _discoverUtils = require("@kbn/discover-utils");
var _external_vis_context = require("../utils/external_vis_context");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ChartConfigPanel({
  services,
  visContext,
  lensAdapters,
  dataLoading$,
  currentSuggestionContext,
  isFlyoutVisible,
  setIsFlyoutVisible,
  isPlainRecord,
  query,
  onSuggestionContextEdit
}) {
  const [editLensConfigPanel, setEditLensConfigPanel] = (0, _react.useState)(null);
  const previousSuggestion = (0, _react.useRef)(undefined);
  const previousAdapters = (0, _react.useRef)(undefined);
  const previousQuery = (0, _react.useRef)(undefined);
  const updatePanelState = (0, _react.useCallback)((datasourceState, visualizationState, visualizationId) => {
    var _ref, _currentSuggestionCon;
    const updatedSuggestion = {
      ...currentSuggestionContext.suggestion,
      visualizationId: (_ref = visualizationId !== null && visualizationId !== void 0 ? visualizationId : (_currentSuggestionCon = currentSuggestionContext.suggestion) === null || _currentSuggestionCon === void 0 ? void 0 : _currentSuggestionCon.visualizationId) !== null && _ref !== void 0 ? _ref : '',
      ...((0, _lodash.isObject)(datasourceState) && {
        datasourceState
      }),
      ...((0, _lodash.isObject)(visualizationState) && {
        visualizationState
      })
    };
    onSuggestionContextEdit({
      ...currentSuggestionContext,
      suggestion: updatedSuggestion
    });
  }, [currentSuggestionContext, onSuggestionContextEdit]);
  const updateSuggestion = (0, _react.useCallback)(attributes => {
    const updatedSuggestion = (0, _external_vis_context.deriveLensSuggestionFromLensAttributes)({
      externalVisContext: {
        ...visContext,
        attributes
      },
      queryParams: null // skip validation for matching query
    });
    onSuggestionContextEdit({
      type: _types.UnifiedHistogramSuggestionType.lensSuggestion,
      suggestion: updatedSuggestion
    });
  }, [onSuggestionContextEdit, visContext]);
  const currentSuggestion = currentSuggestionContext.suggestion;
  const currentSuggestionType = currentSuggestionContext.type;
  (0, _react.useEffect)(() => {
    var _lensAdapters$tables, _previousSuggestion$c;
    const tablesAdapters = lensAdapters === null || lensAdapters === void 0 ? void 0 : (_lensAdapters$tables = lensAdapters.tables) === null || _lensAdapters$tables === void 0 ? void 0 : _lensAdapters$tables.tables;
    const dataHasChanged = Boolean(tablesAdapters) && !(0, _lodash.isEqual)(previousAdapters.current, tablesAdapters) && query !== (previousQuery === null || previousQuery === void 0 ? void 0 : previousQuery.current);
    async function fetchLensConfigComponent() {
      const Component = await services.lens.EditLensConfigPanelApi();
      const panel = /*#__PURE__*/_react.default.createElement(Component, {
        attributes: visContext.attributes,
        updateSuggestion: updateSuggestion,
        updatePanelState: updatePanelState,
        lensAdapters: lensAdapters,
        dataLoading$: dataLoading$,
        displayFlyoutHeader: true,
        closeFlyout: () => {
          setIsFlyoutVisible(false);
        },
        wrapInFlyout: true,
        datasourceId: "textBased",
        hidesSuggestions: currentSuggestionType !== _types.UnifiedHistogramSuggestionType.lensSuggestion
      });
      setEditLensConfigPanel(panel);
      previousSuggestion.current = currentSuggestion;
      previousAdapters.current = tablesAdapters;
      if (dataHasChanged) {
        previousQuery.current = query;
      }
    }
    const suggestionHasChanged = (currentSuggestion === null || currentSuggestion === void 0 ? void 0 : currentSuggestion.title) !== (previousSuggestion === null || previousSuggestion === void 0 ? void 0 : (_previousSuggestion$c = previousSuggestion.current) === null || _previousSuggestion$c === void 0 ? void 0 : _previousSuggestion$c.title);
    // rerender the component if the data has changed
    if (isPlainRecord && (dataHasChanged || suggestionHasChanged || !isFlyoutVisible)) {
      fetchLensConfigComponent();
    }
  }, [visContext.attributes, services.lens, updatePanelState, updateSuggestion, isPlainRecord, currentSuggestion, query, isFlyoutVisible, setIsFlyoutVisible, lensAdapters, dataLoading$, currentSuggestionType]);
  const flyoutElement = isPlainRecord ? editLensConfigPanel : null;
  (0, _react.useEffect)(() => {
    if (flyoutElement) {
      (0, _discoverUtils.dismissAllFlyoutsExceptFor)(_discoverUtils.DiscoverFlyouts.lensEdit);
    }
  }, [flyoutElement]);
  return flyoutElement;
}