"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewFields = void 0;
var _react = require("react");
var _dataViewUtils = require("@kbn/data-view-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useDataViewFields = ({
  fields,
  dataView,
  columnsMeta
}) => {
  const dataViewFields = (0, _react.useMemo)(() => fields.reduce((acc, fieldName) => {
    acc[fieldName] = (0, _dataViewUtils.getDataViewFieldOrCreateFromColumnMeta)({
      fieldName,
      dataView,
      columnMeta: columnsMeta === null || columnsMeta === void 0 ? void 0 : columnsMeta[fieldName]
    });
    return acc;
  }, {}), [fields, dataView, columnsMeta]);
  return {
    dataViewFields
  };
};
exports.useDataViewFields = useDataViewFields;