"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionSummaryField = TransactionSummaryField;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _field_with_actions = require("../../components/field_with_actions/field_with_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function TransactionSummaryField({
  fieldConfiguration,
  fieldId,
  fieldMapping,
  showActions = true
}) {
  if (!fieldConfiguration.value) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_with_actions.FieldWithActions, {
    "data-test-subj": `unifiedDocViewerObservabilityTracesAttribute-${fieldId}`,
    label: fieldConfiguration.title,
    field: fieldId,
    fieldMapping: fieldMapping,
    value: fieldConfiguration.value,
    formattedValue: fieldConfiguration.value,
    fieldMetadata: fieldConfiguration.fieldMetadata,
    showActions: showActions
  }, /*#__PURE__*/_react.default.createElement("div", null, fieldConfiguration.content(fieldConfiguration.value, fieldConfiguration.formattedValue))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }));
}