"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionFieldConfiguration = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _get_field_configuration = require("../../resources/get_field_configuration");
var _highlight_field = require("../../components/highlight_field.tsx");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getTransactionFieldConfiguration = ({
  attributes,
  flattenedDoc
}) => {
  return {
    ...(0, _get_field_configuration.getCommonFieldConfiguration)({
      attributes,
      flattenedDoc
    }),
    [_discoverUtils.USER_AGENT_NAME_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.userAgent.title', {
        defaultMessage: 'User agent'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }),
      value: flattenedDoc[_discoverUtils.USER_AGENT_NAME_FIELD],
      formattedValue: attributes[_discoverUtils.USER_AGENT_NAME_FIELD]
    },
    [_discoverUtils.USER_AGENT_VERSION_FIELD]: {
      title: _i18n.i18n.translate('unifiedDocViewer.observability.traces.details.userAgentVersion.title', {
        defaultMessage: 'User agent version'
      }),
      content: (value, formattedValue) => /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, {
        value: value,
        formattedValue: formattedValue
      }),
      value: flattenedDoc[_discoverUtils.USER_AGENT_VERSION_FIELD],
      formattedValue: attributes[_discoverUtils.USER_AGENT_VERSION_FIELD]
    }
  };
};
exports.getTransactionFieldConfiguration = getTransactionFieldConfiguration;