"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootTransactionContext = exports.RootTransactionProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _rxjs = require("rxjs");
var _plugin = require("../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getRootTransaction({
  data,
  signal,
  traceId,
  indexPattern
}) {
  return (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [_discoverUtils.TRANSACTION_DURATION_FIELD, _discoverUtils.SPAN_ID_FIELD, _discoverUtils.SERVICE_NAME_FIELD, _discoverUtils.TRANSACTION_ID_FIELD],
        query: {
          bool: {
            should: [{
              constant_score: {
                filter: {
                  bool: {
                    must_not: {
                      exists: {
                        field: _discoverUtils.PARENT_ID_FIELD
                      }
                    }
                  }
                }
              }
            }],
            filter: [{
              term: {
                [_discoverUtils.TRACE_ID_FIELD]: traceId
              }
            }]
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
}
const useRootTransaction = ({
  traceId,
  indexPattern
}) => {
  const {
    core,
    data
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [transaction, setTransaction] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (!traceId) {
      setTransaction(null);
      setLoading(false);
      return;
    }
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const fetchData = async () => {
      try {
        var _result$rawResponse$h;
        setLoading(true);
        const result = await getRootTransaction({
          data,
          signal,
          traceId,
          indexPattern
        });
        const fields = (_result$rawResponse$h = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h === void 0 ? void 0 : _result$rawResponse$h.fields;
        const transactionDuration = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.TRANSACTION_DURATION_FIELD];
        const spanId = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.SPAN_ID_FIELD];
        const transactionId = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.TRANSACTION_ID_FIELD];
        const serviceName = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.SERVICE_NAME_FIELD];
        setTransaction({
          duration: transactionDuration,
          [_discoverUtils.SPAN_ID_FIELD]: spanId,
          [_discoverUtils.TRANSACTION_ID_FIELD]: transactionId,
          [_discoverUtils.SERVICE_NAME_FIELD]: serviceName
        });
      } catch (err) {
        if (!signal.aborted) {
          const error = err;
          core.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('unifiedDocViewer.docViewerSpanOverview.useRootTransaction.error', {
              defaultMessage: 'An error occurred while fetching the transaction'
            }),
            text: error.message
          });
          setTransaction(null);
        }
      } finally {
        setLoading(false);
      }
    };
    fetchData();
    return function onUnmount() {
      controller.abort();
    };
  }, [data, core.notifications.toasts, traceId, indexPattern]);
  return {
    loading,
    transaction
  };
};
const [RootTransactionProvider, useRootTransactionContext] = (0, _constate.default)(useRootTransaction);
exports.useRootTransactionContext = useRootTransactionContext;
exports.RootTransactionProvider = RootTransactionProvider;