"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootSpanContext = exports.RootSpanProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _plugin = require("../../../../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getRootSpanData({
  traceId,
  transactionId,
  indexPattern,
  data,
  signal
}) {
  return (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: indexPattern,
      size: 1,
      body: {
        timeout: '20s',
        fields: [_discoverUtils.TRANSACTION_NAME_FIELD, _discoverUtils.TRANSACTION_DURATION_FIELD, _discoverUtils.SPAN_NAME_FIELD, _discoverUtils.SPAN_DURATION_FIELD, _discoverUtils.OTEL_DURATION],
        query: {
          bool: transactionId ? {
            must: [{
              term: {
                [_discoverUtils.TRANSACTION_ID_FIELD]: transactionId
              }
            }, {
              term: {
                [_discoverUtils.PROCESSOR_EVENT_FIELD]: 'transaction'
              }
            }]
          } : {
            must: [{
              term: {
                [_discoverUtils.TRACE_ID_FIELD]: traceId
              }
            }],
            must_not: [{
              exists: {
                field: _discoverUtils.PARENT_ID_FIELD
              }
            }, {
              exists: {
                field: 'parent_span_id'
              }
            }]
          }
        }
      }
    }
  }, {
    abortSignal: signal
  }));
}
const useRootSpan = ({
  traceId,
  transactionId,
  indexPattern
}) => {
  const {
    data,
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const [trace, setTrace] = (0, _react.useState)(null);
  const [loading, setLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (!traceId) {
      setTrace(null);
      setLoading(false);
      return;
    }
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const fetchData = async () => {
      try {
        var _result$rawResponse$h;
        setLoading(true);
        const result = await getRootSpanData({
          traceId,
          transactionId,
          indexPattern,
          data,
          signal
        });
        const fields = (_result$rawResponse$h = result.rawResponse.hits.hits[0]) === null || _result$rawResponse$h === void 0 ? void 0 : _result$rawResponse$h.fields;
        const name = (fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.TRANSACTION_NAME_FIELD]) || (fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.SPAN_NAME_FIELD]);
        const duration = resolveDuration(fields);
        if (name && duration) {
          setTrace({
            name,
            duration
          });
        }
      } catch (err) {
        if (!signal.aborted) {
          const error = err;
          core.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('unifiedDocViewer.docViewerSpanOverview.useTrace.error', {
              defaultMessage: 'An error occurred while fetching the trace'
            }),
            text: error.message
          });
          setTrace(null);
        }
      } finally {
        setLoading(false);
      }
    };
    fetchData();
    return function onUnmount() {
      controller.abort();
    };
  }, [core.notifications.toasts, data, indexPattern, traceId, transactionId]);
  return {
    loading,
    trace
  };
};
const [RootSpanProvider, useRootSpanContext] = (0, _constate.default)(useRootSpan);
exports.useRootSpanContext = useRootSpanContext;
exports.RootSpanProvider = RootSpanProvider;
function resolveDuration(fields) {
  const duration = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.TRANSACTION_DURATION_FIELD];
  if (duration) {
    return duration;
  }
  const otelDuration = fields === null || fields === void 0 ? void 0 : fields[_discoverUtils.OTEL_DURATION];
  if (otelDuration) {
    return otelDuration * 0.001;
  }
  return null;
}