"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpStatusCode = HttpStatusCode;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _http_status_codes = require("./http_status_codes");
var _use_get_http_status_color = require("./use_get_http_status_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function HttpStatusCode({
  code
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _use_get_http_status_color.useGetHttpStatusColor)(code),
    "data-test-subj": "unifiedDocViewerObservabilityTracesHttpStatusCodeBadge"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "unifiedDocViewerObservabilityTracesHttpStatusCodeText"
  }, code, " ", _http_status_codes.httpStatusCodes[code.toString()]));
}