"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewTableRowBtnFilterRemove = DocViewTableRowBtnFilterRemove;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DocViewTableRowBtnFilterRemove({
  onClick,
  disabled = false
}) {
  const tooltipContent = disabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.docViews.table.unindexedFieldsCanNotBeSearchedTooltip",
    defaultMessage: "Unindexed fields or ignored values cannot be searched"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.docViews.table.filterOutValueButtonTooltip",
    defaultMessage: "Filter out value"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterOutValueButtonAriaLabel', {
      defaultMessage: 'Filter out value'
    }),
    className: "kbnDocViewer__actionButton",
    "data-test-subj": "removeInclusiveFilterButton",
    disabled: disabled,
    onClick: onClick,
    iconType: 'minusInCircle',
    iconSize: 's'
  }));
}