"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceIdHighlightField = TraceIdHighlightField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _highlight_field = require("./highlight_field");
var _plugin = require("../../../plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR = 'TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR';
function TraceIdHighlightField(props) {
  var _core$application$cap;
  const {
    share: {
      url: urlService
    },
    core
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const canViewApm = ((_core$application$cap = core.application.capabilities.apm) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show) || false;
  const apmLinkToServiceEntityLocator = urlService.locators.get(TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR);
  const href = apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.getRedirectUrl({
    traceId: props.value
  });
  const routeLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href,
    onClick: () => apmLinkToServiceEntityLocator === null || apmLinkToServiceEntityLocator === void 0 ? void 0 : apmLinkToServiceEntityLocator.navigate({
      traceId: props.value
    })
  });
  return /*#__PURE__*/_react.default.createElement(_highlight_field.HighlightField, props, canViewApm ? ({
    content
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, routeLinkProps, {
    "data-test-subj": "unifiedDocViewLogsOverviewTraceIdHighlightLink"
  }), content) : undefined);
}