"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionInternal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @internal
 */
class ActionInternal {
  constructor(definition) {
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", void 0);
    (0, _defineProperty2.default)(this, "grouping", void 0);
    (0, _defineProperty2.default)(this, "showNotification", void 0);
    (0, _defineProperty2.default)(this, "disabled", void 0);
    (0, _defineProperty2.default)(this, "getCompatibilityChangesSubject", void 0);
    (0, _defineProperty2.default)(this, "couldBecomeCompatible", void 0);
    (0, _defineProperty2.default)(this, "errorLogged", void 0);
    this.definition = definition;
    this.id = this.definition.id;
    this.type = this.definition.type || '';
    this.order = this.definition.order || 0;
    this.MenuItem = this.definition.MenuItem;
    this.grouping = this.definition.grouping;
    this.showNotification = this.definition.showNotification;
    this.disabled = this.definition.disabled;
    this.errorLogged = false;
    if (this.definition.getCompatibilityChangesSubject) {
      this.getCompatibilityChangesSubject = definition.getCompatibilityChangesSubject;
    }
    if (this.definition.couldBecomeCompatible) {
      this.couldBecomeCompatible = definition.couldBecomeCompatible;
    }
  }
  async execute(context) {
    try {
      return await this.definition.execute(context);
    } catch (e) {
      var _getNotifications;
      (_getNotifications = (0, _services.getNotifications)()) === null || _getNotifications === void 0 ? void 0 : _getNotifications.toasts.addWarning(_i18n.i18n.translate('uiActions.execute.unhandledErrorMsg', {
        defaultMessage: `Unable to execute action, error: {errorMessage}`,
        values: {
          errorMessage: e.message
        }
      }));
    }
  }
  getIconType(context) {
    if (!this.definition.getIconType) return undefined;
    return this.definition.getIconType(context);
  }
  getDisplayName(context) {
    if (!this.definition.getDisplayName) return `Action: ${this.id}`;
    return this.definition.getDisplayName(context);
  }
  getDisplayNameTooltip(context) {
    if (!this.definition.getDisplayNameTooltip) return '';
    return this.definition.getDisplayNameTooltip(context);
  }
  async isCompatible(context) {
    if (!this.definition.isCompatible) return true;
    try {
      return await this.definition.isCompatible(context);
    } catch (e) {
      if (!this.errorLogged) {
        // eslint-disable-next-line no-console
        console.error(e);
        this.errorLogged = true;
      }
      return false;
    }
  }
  async getHref(context) {
    if (!this.definition.getHref) return undefined;
    return await this.definition.getHref(context);
  }
  async shouldAutoExecute(context) {
    if (!this.definition.shouldAutoExecute) return false;
    return this.definition.shouldAutoExecute(context);
  }
}
exports.ActionInternal = ActionInternal;