"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_GROUPS = void 0;
Object.defineProperty(exports, "TIME_SERIES_BUCKET_SELECTOR_FIELD", {
  enumerable: true,
  get: function () {
    return _lib.TIME_SERIES_BUCKET_SELECTOR_FIELD;
  }
});
exports.getService = getService;
exports.register = register;
var _time_series_query = require("./lib/time_series_query");
var _routes = require("./routes");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// future enhancement: make these configurable?
const DEFAULT_GROUPS = exports.DEFAULT_GROUPS = 100;
function getService() {
  return {
    timeSeriesQuery: _time_series_query.timeSeriesQuery
  };
}
function register(params) {
  const {
    logger,
    router,
    data,
    baseRoute
  } = params;
  const baseBuiltInRoute = `${baseRoute}/data`;
  (0, _routes.registerRoutes)({
    logger,
    router,
    data,
    baseRoute: baseBuiltInRoute
  });
}