"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  PLUGIN_ID: true,
  ALERTS_PAGE_ID: true,
  CONNECTORS_PLUGIN_ID: true,
  builtInComparators: true,
  VIEW_LICENSE_OPTIONS_LINK: true,
  AGGREGATION_TYPES: true,
  builtInAggregationTypes: true,
  loadAllActions: true,
  loadActionTypes: true,
  ConnectorAddModal: true,
  builtInGroupByTypes: true,
  I18N_WEEKDAY_OPTIONS: true,
  I18N_WEEKDAY_OPTIONS_DDD: true
};
Object.defineProperty(exports, "AGGREGATION_TYPES", {
  enumerable: true,
  get: function () {
    return _aggregation_types.AGGREGATION_TYPES;
  }
});
exports.CONNECTORS_PLUGIN_ID = exports.ALERTS_PAGE_ID = void 0;
Object.defineProperty(exports, "ConnectorAddModal", {
  enumerable: true,
  get: function () {
    return _action_connector_form.ConnectorAddModal;
  }
});
Object.defineProperty(exports, "I18N_WEEKDAY_OPTIONS", {
  enumerable: true,
  get: function () {
    return _i18n_weekdays.I18N_WEEKDAY_OPTIONS;
  }
});
Object.defineProperty(exports, "I18N_WEEKDAY_OPTIONS_DDD", {
  enumerable: true,
  get: function () {
    return _i18n_weekdays.I18N_WEEKDAY_OPTIONS_DDD;
  }
});
exports.PLUGIN_ID = void 0;
Object.defineProperty(exports, "VIEW_LICENSE_OPTIONS_LINK", {
  enumerable: true,
  get: function () {
    return _constants.VIEW_LICENSE_OPTIONS_LINK;
  }
});
Object.defineProperty(exports, "builtInAggregationTypes", {
  enumerable: true,
  get: function () {
    return _aggregation_types.builtInAggregationTypes;
  }
});
exports.builtInComparators = void 0;
Object.defineProperty(exports, "builtInGroupByTypes", {
  enumerable: true,
  get: function () {
    return _group_by_types.builtInGroupByTypes;
  }
});
Object.defineProperty(exports, "loadActionTypes", {
  enumerable: true,
  get: function () {
    return _action_connector_api.loadActionTypes;
  }
});
Object.defineProperty(exports, "loadAllActions", {
  enumerable: true,
  get: function () {
    return _action_connector_api.loadAllActions;
  }
});
var _alertingComparators = require("@kbn/alerting-comparators");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/alerts-ui-shared/src/common/constants");
var _aggregation_types = require("./aggregation_types");
var _action_connector_api = require("../../application/lib/action_connector_api");
var _action_connector_form = require("../../application/sections/action_connector_form");
var _group_by_types = require("./group_by_types");
var _action_frequency_types = require("./action_frequency_types");
Object.keys(_action_frequency_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _action_frequency_types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _action_frequency_types[key];
    }
  });
});
var _i18n_weekdays = require("@kbn/alerts-ui-shared/src/common/constants/i18n_weekdays");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'triggersActions';
const ALERTS_PAGE_ID = exports.ALERTS_PAGE_ID = 'triggersActionsAlerts';
const CONNECTORS_PLUGIN_ID = exports.CONNECTORS_PLUGIN_ID = 'triggersActionsConnectors';
const builtInComparators = exports.builtInComparators = {
  [_alertingComparators.COMPARATORS.GREATER_THAN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isAboveLabel', {
      defaultMessage: 'Is above'
    }),
    value: _alertingComparators.COMPARATORS.GREATER_THAN,
    requiredValues: 1
  },
  [_alertingComparators.COMPARATORS.GREATER_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isAboveOrEqualsLabel', {
      defaultMessage: 'Is above or equals'
    }),
    value: _alertingComparators.COMPARATORS.GREATER_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [_alertingComparators.COMPARATORS.LESS_THAN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBelowLabel', {
      defaultMessage: 'Is below'
    }),
    value: _alertingComparators.COMPARATORS.LESS_THAN,
    requiredValues: 1
  },
  [_alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBelowOrEqualsLabel', {
      defaultMessage: 'Is below or equals'
    }),
    value: _alertingComparators.COMPARATORS.LESS_THAN_OR_EQUALS,
    requiredValues: 1
  },
  [_alertingComparators.COMPARATORS.BETWEEN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isBetweenLabel', {
      defaultMessage: 'Is between'
    }),
    value: _alertingComparators.COMPARATORS.BETWEEN,
    requiredValues: 2
  },
  [_alertingComparators.COMPARATORS.NOT_BETWEEN]: {
    text: _i18n.i18n.translate('xpack.triggersActionsUI.common.constants.comparators.isNotBetweenLabel', {
      defaultMessage: 'Is not between'
    }),
    value: _alertingComparators.COMPARATORS.NOT_BETWEEN,
    requiredValues: 2
  }
};