"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertRuleFromVisAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/expressions-plugin/common");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _triggers = require("@kbn/ui-actions-browser/src/triggers");
var _lodash = require("lodash");
var _presentationContainers = require("@kbn/presentation-containers");
var _build_additional_query = require("./build_additional_query");
var _rule_flyout_component = require("./rule_flyout_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AlertRuleFromVisAction {
  constructor(ruleTypeRegistry, actionTypeRegistry, startDependencies) {
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "actionTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "startDependencies", void 0);
    (0, _defineProperty2.default)(this, "type", _triggers.ALERT_RULE_TRIGGER);
    (0, _defineProperty2.default)(this, "id", _triggers.ALERT_RULE_TRIGGER);
    (0, _defineProperty2.default)(this, "getIconType", () => 'bell');
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.actionName', {
      defaultMessage: 'Create alert rule'
    }));
    (0, _defineProperty2.default)(this, "shouldAutoExecute", async () => true);
    this.ruleTypeRegistry = ruleTypeRegistry;
    this.actionTypeRegistry = actionTypeRegistry;
    this.startDependencies = startDependencies;
  }
  async isCompatible({
    embeddable
  }) {
    const isLensApi = (0, _presentationPublishing.apiIsOfType)(embeddable, 'lens');
    if (!isLensApi || (0, _presentationPublishing.hasBlockingError)(embeddable)) return false;
    const query = embeddable.query$.getValue();
    return Boolean(query && 'esql' in query);
  }
  async execute({
    embeddable,
    data
  }) {
    var _embeddable$dataViews, _embeddable$serialize, _state$datasourceStat, _state$datasourceStat2;
    const embeddableData = data !== null && data !== void 0 && data.query ? data : data ? {
      ...data,
      ...(0, _lodash.pick)(getDataFromEmbeddable(embeddable), ['query', 'dataView', 'usesPlaceholderValues'])
    } : getDataFromEmbeddable(embeddable);
    const {
      query
    } = embeddableData;

    // Get the timeField, default to `timestamp` if it can't be found
    const datatable = getDataTableFromEmbeddable(embeddable);
    const dataView = query ? undefined : (_embeddable$dataViews = embeddable.dataViews$.getValue()) === null || _embeddable$dataViews === void 0 ? void 0 : _embeddable$dataViews.find(view => {
      var _datatable$meta;
      return view.id === (datatable === null || datatable === void 0 ? void 0 : (_datatable$meta = datatable.meta) === null || _datatable$meta === void 0 ? void 0 : _datatable$meta.source);
    });
    const {
      state
    } = (_embeddable$serialize = embeddable.serializeState().rawState.attributes) !== null && _embeddable$serialize !== void 0 ? _embeddable$serialize : {};
    const layers = state === null || state === void 0 ? void 0 : (_state$datasourceStat = state.datasourceStates) === null || _state$datasourceStat === void 0 ? void 0 : (_state$datasourceStat2 = _state$datasourceStat.textBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers;
    const [firstLayer] = Object.values(layers !== null && layers !== void 0 ? layers : {});
    const {
      timeField = 'timestamp'
    } = firstLayer !== null && firstLayer !== void 0 ? firstLayer : {
      timeField: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName
    };

    // Generate additional query to append to the base ES|QL query from the visualization
    const additionalQuery = (0, _build_additional_query.buildAdditionalQuery)(embeddableData);

    // Assemble the full ES|QL code
    let initialValues;
    if (query) {
      const queryHeader = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.queryHeaderComment', {
        defaultMessage: 'Original ES|QL query derived from the visualization:'
      });
      initialValues = {
        params: {
          searchType: 'esqlQuery',
          esqlQuery: {
            esql: `// ${queryHeader}\n${query}\n${additionalQuery}`
          },
          timeField
        }
      };
    } else {
      const missingQueryComment = `// ${_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.missingQueryComment', {
        defaultMessage: 'Unable to generate an ES|QL query from the visualization.'
      })}`;
      let esql = missingQueryComment;
      if (dataView) {
        const [index] = dataView.matchedIndices;
        const esqlFromDataviewComment = `// ${_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.esqlFromDataviewComment', {
          defaultMessage: 'Unable to automatically generate an ES|QL query that produces the same data as this visualization. You may be able to reproduce it manually using this data source:'
        })}`;
        const dataViewQuery = `FROM ${index}`;
        esql = `${esqlFromDataviewComment}\n${dataViewQuery}\n${additionalQuery}`;
      }
      initialValues = {
        params: {
          searchType: 'esqlQuery',
          esqlQuery: {
            esql
          },
          timeField
        }
      };
    }
    const parentApi = embeddable.parentApi;
    const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
    const Component = await (0, _rule_flyout_component.getRuleFlyoutComponent)(this.startDependencies, this.ruleTypeRegistry, this.actionTypeRegistry, parentApi, {
      ...initialValues,
      tags: [],
      name: _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.embeddable.alertRuleTitle.defaultName', {
        defaultMessage: 'Elasticsearch query rule from visualization'
      })
    });
    embeddable.mountInlineFlyout(Component, overlayTracker, {
      dataTestSubj: 'lensAlertRule'
    });
  }
}
exports.AlertRuleFromVisAction = AlertRuleFromVisAction;
const getDataTableFromEmbeddable = embeddable => {
  var _embeddable$getInspec;
  return Object.values((_embeddable$getInspec = embeddable.getInspectorAdapters().tables.tables) !== null && _embeddable$getInspec !== void 0 ? _embeddable$getInspec : {})[0];
};
const getDataFromEmbeddable = embeddable => {
  const queryValue = embeddable.query$.getValue();
  const query = queryValue && 'esql' in queryValue ? queryValue.esql : null;
  const datatable = getDataTableFromEmbeddable(embeddable);
  const thresholdValues = datatable ? datatable.columns.filter(col => col.meta.dimensionType === _common.DimensionType.Y_AXIS).map(({
    meta
  }) => {
    var _meta$sourceParams;
    const {
      sourceField = missingYFieldPlaceholder
    } = (_meta$sourceParams = meta.sourceParams) !== null && _meta$sourceParams !== void 0 ? _meta$sourceParams : {};
    return {
      values: {
        [String(sourceField)]: _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.thresholdPlaceholder', {
          defaultMessage: '[THRESHOLD]'
        })
      },
      yField: String(sourceField)
    };
  }) : [];
  const xColumns = datatable === null || datatable === void 0 ? void 0 : datatable.columns.filter(col => col.meta.dimensionType === _common.DimensionType.X_AXIS);
  const isTimeViz = xColumns === null || xColumns === void 0 ? void 0 : xColumns.some(({
    meta
  }) => meta.type === 'date');
  const xValues = isTimeViz || !xColumns ? {} : xColumns.reduce((result, {
    meta
  }) => {
    var _meta$sourceParams2;
    const {
      sourceField = missingXFieldPlaceholder
    } = (_meta$sourceParams2 = meta.sourceParams) !== null && _meta$sourceParams2 !== void 0 ? _meta$sourceParams2 : {};
    return {
      ...result,
      [String(sourceField)]: [_i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.splitValuePlaceholder', {
        defaultMessage: '[VALUE]'
      })]
    };
  }, {});
  return {
    query,
    xValues,
    thresholdValues,
    usesPlaceholderValues: true
  };
};
const missingYFieldPlaceholder = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.yAxisPlaceholder', {
  defaultMessage: '[Y AXIS]'
});
const missingXFieldPlaceholder = _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.xAxisPlaceholder', {
  defaultMessage: '[X AXIS]'
});