"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _common = require("../../api_schemas/common");
var _update_transforms = require("../../api_schemas/update_transforms");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  getLicense
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/transforms/:transformId/_update Post transform update
   * @apiName PostTransformUpdate
   * @apiDescription Updates a transform
   *
   * @apiSchema (params) transformIdParamSchema
   * @apiSchema (body) postTransformsUpdateRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('transforms/{transformId}/_update'),
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    },
    validate: {
      request: {
        params: _common.transformIdParamSchema,
        body: _update_transforms.postTransformsUpdateRequestSchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute(_route_handler.routeHandler)(ctx, request, response);
  });
}