"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _reauthorize_transforms = require("../../api_schemas/reauthorize_transforms");
var _constants = require("../../../../common/constants");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute(routeDependencies) {
  const {
    router,
    getLicense
  } = routeDependencies;
  /**
   * @apiGroup Reauthorize transforms with API key generated from currently logged in user
   * @api {post} /internal/transform/reauthorize_transforms Post reauthorize transforms
   * @apiName Reauthorize Transforms
   * @apiDescription Reauthorize transforms by generating an API Key for current user
   * and update transform's es-secondary-authorization headers with the generated key,
   * then start the transform.
   * @apiSchema (body) reauthorizeTransformsRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('reauthorize_transforms'),
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    },
    validate: {
      request: {
        body: _reauthorize_transforms.reauthorizeTransformsRequestSchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute((0, _route_handler_factory.routeHandlerFactory)(routeDependencies))(ctx, request, response);
  });
}