"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlStringHash = require("@kbn/ml-string-hash");
var _expanded_row_details_pane = require("./expanded_row_details_pane");
var _expanded_row_json_pane = require("./expanded_row_json_pane");
var _expanded_row_messages_pane = require("./expanded_row_messages_pane");
var _expanded_row_preview_pane = require("./expanded_row_preview_pane");
var _expanded_row_health_pane = require("./expanded_row_health_pane");
var _expanded_row_stats_pane = require("./expanded_row_stats_pane");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRow = ({
  item,
  onAlertEdit
}) => {
  var _item$stats;
  const tabId = (0, _mlStringHash.stringHash)(item.id);
  const tabs = [{
    id: `transform-details-tab-${tabId}`,
    'data-test-subj': 'transformDetailsTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformDetailsLabel', {
      defaultMessage: 'Details'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_details_pane.ExpandedRowDetailsPane, {
      item: item,
      onAlertEdit: onAlertEdit
    })
  }, {
    id: `transform-stats-tab-${tabId}`,
    'data-test-subj': 'transformStatsTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformStatsLabel', {
      defaultMessage: 'Stats'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_stats_pane.ExpandedRowStatsPane, {
      item: item
    })
  }, {
    id: `transform-json-tab-${tabId}`,
    'data-test-subj': 'transformJsonTab',
    name: 'JSON',
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_json_pane.ExpandedRowJsonPane, {
      json: item.config
    })
  }, ...((_item$stats = item.stats) !== null && _item$stats !== void 0 && _item$stats.health ? [{
    id: `transform-health-tab-${tabId}`,
    'data-test-subj': 'transformHealthTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformHealthLabel', {
      defaultMessage: 'Health'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_health_pane.ExpandedRowHealthPane, {
      health: item.stats.health
    })
  }] : []), {
    id: `transform-messages-tab-${tabId}`,
    'data-test-subj': 'transformMessagesTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformMessagesLabel', {
      defaultMessage: 'Messages'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_messages_pane.ExpandedRowMessagesPane, {
      transformId: item.id
    })
  }, {
    id: `transform-preview-tab-${tabId}`,
    'data-test-subj': 'transformPreviewTab',
    name: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.tabs.transformPreviewLabel', {
      defaultMessage: 'Preview'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_preview_pane.ExpandedRowPreviewPane, {
      transformConfig: item.config
    })
  }];

  // Using `expand=false` here so the tabs themselves don't spread
  // across the full width. The 100% width is used so the bottom line
  // as well as the tab content spans across the full width,
  // even if the tab content wouldn't extend to the full width.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    onTabClick: () => {},
    expand: false,
    css: (0, _react2.css)`
        width: 100%;

        .euiTable {
          background-color: transparent;
        }
      `,
    "data-test-subj": "transformExpandedRowTabbedContent"
  });
};
exports.ExpandedRow = ExpandedRow;