"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchSelection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _app_dependencies = require("../../../../app_dependencies");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fixedPageSize = 8;
const SearchSelection = ({
  onSearchSelected,
  createNewDataView,
  canEditDataView
}) => {
  const {
    contentManagement,
    uiSettings
  } = (0, _app_dependencies.useAppDependencies)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.newTransformTitle",
    defaultMessage: "New transform"
  }), ' ', "/", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.chooseSourceTitle",
    defaultMessage: "Choose a source"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "transformMgtSearchSelection",
    key: "searchSavedObjectFinder",
    onChoose: onSearchSelected,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching indices or saved Discover sessions found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'discoverApp',
      name: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.savedObjectType.discoverSession', {
        defaultMessage: 'Discover session'
      }),
      showSavedObject: savedObject =>
      // ES|QL Based saved searches are not supported in transforms, filter them out
      savedObject.attributes.isTextBasedQuery !== true
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.transform.newTransform.searchSelection.savedObjectType.dataView', {
        defaultMessage: 'Data view'
      })
    }],
    fixedPageSize: fixedPageSize,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    }
  }, canEditDataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: createNewDataView,
    iconType: "plusInCircle",
    "data-test-subj": "newDataViewButton",
    disabled: !canEditDataView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.newTransform.searchSelection.createADataView",
    defaultMessage: "Create a data view"
  })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null))));
};
exports.SearchSelection = SearchSelection;